#include <string.h>

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>

#define ACTION_TYPE		"lock"
#define TOUCH_CRUISER_VAL	"OAFIID:TouchcruiserApplet"
#define MENU_PATH		"applications:/"
#define OBJECT_TYPE		"bonobo-applet"
#define TOPLEVEL_ID		"top_panel_screen0"
#define APPLET_ID_LIST		"/apps/panel/general/applet_id_list"

int main(int argc, char *argv[])
{
	GConfClient *client;
	gchar		key[50];
	gchar		strval[50];
	gchar		data[10];
	gchar 		*val;
	gint		intval;
	gint		i = 0;
	GError 		*error = (GError*)NULL;
	gboolean	boolval;
	GSList		*list;
	GSList		*l;

	gtk_set_locale();
	gtk_init (&argc, &argv);

	client = gconf_client_get_default();

	list = gconf_client_get_list (client, APPLET_ID_LIST, GCONF_VALUE_STRING, &error);
	if( error ){
		return 0;
	}

	for (l = list; l; l = l->next)
	{
//		g_print(" List = [%s]\n",(char *)l->data);
		sprintf( key, "/apps/panel/applets/%s/bonobo_iid", (char *)l->data );
		val = gconf_client_get_string (client, key, &error);
		if( strcmp ( (char *)val, TOUCH_CRUISER_VAL ) == 0 ){
//			g_print("error 2 [%s]\n",val);
			return 0;
		}
	}

	while( 1 ){
		val = (gchar*)NULL;
		sprintf( data, "applet_%d", i );
		sprintf( key, "/apps/panel/applets/applet_%d/bonobo_iid", i );
		val = gconf_client_get_string (client, key, &error);

		if( val == NULL ){
			sprintf( strval, ACTION_TYPE );
			sprintf( key, "/apps/panel/applets/applet_%d/action_type", i );
			gconf_client_set_string (client, key, strval, &error);

			strval[0] = NULL;
			sprintf( key, "/apps/panel/applets/applet_%d/attached_toplevel_id", i );
			gconf_client_set_string (client, key, strval, &error);

			sprintf( strval, TOUCH_CRUISER_VAL );
			sprintf( key, "/apps/panel/applets/applet_%d/bonobo_iid", i );
			gconf_client_set_string (client, key, strval, &error);

			strval[0] = NULL;
			sprintf( key, "/apps/panel/applets/applet_%d/custom_icon", i );
			gconf_client_set_string (client, key, strval, &error);

			sprintf( key, "/apps/panel/applets/applet_%d/launcher_location", i );
			gconf_client_set_string (client, key, strval, &error);

			boolval = TRUE;
			sprintf( key, "/apps/panel/applets/applet_%d/locked", i );
			gconf_client_set_bool (client, key, boolval, &error);

			sprintf( strval, MENU_PATH );
			sprintf( key, "/apps/panel/applets/applet_%d/menu_path", i );
			gconf_client_set_string (client, key, strval, &error);

			sprintf( strval, OBJECT_TYPE );
			sprintf( key, "/apps/panel/applets/applet_%d/object_type", i );
			gconf_client_set_string (client, key, strval, &error);

			boolval = TRUE;
			sprintf( key, "/apps/panel/applets/applet_%d/panel_right_stick", i );
			gconf_client_set_bool (client, key, boolval, &error);

			intval = 300;
			sprintf( key, "/apps/panel/applets/applet_%d/position", i );
			gconf_client_set_int (client, key, intval, &error);

			strval[0] = NULL;
			sprintf( key, "/apps/panel/applets/applet_%d/tooltip", i );
			gconf_client_set_string (client, key, strval, &error);

			sprintf( strval, "top_panel_screen0" );
			sprintf( key, "/apps/panel/applets/applet_%d/toplevel_id", i );
			gconf_client_set_string (client, key, strval, &error);

			boolval = FALSE;
			sprintf( key, "/apps/panel/applets/applet_%d/use_custom_icon", i );
			gconf_client_set_bool (client, key, boolval, &error);

			boolval = FALSE;
			sprintf( key, "/apps/panel/applets/applet_%d/use_menu_path", i );
			gconf_client_set_bool (client, key, boolval, &error);

			break;
		} else {
			if( strcmp ( (char *)val, TOUCH_CRUISER_VAL ) == 0 ){
				break;
			}
//			g_print(" data = [%s]\n",data);
		}
		i++;
	}

	for (l = list; l; l = l->next)
	{
//		g_print(" List = [%s]\n",(char *)l->data);
		if( strcmp ( (char *)l->data, data ) == 0 ){
//			g_print("error 3 [%s]\n",val);
			return 0;
		}
	}

	list = g_slist_append ( list, data  );
	gconf_client_set_list (client, APPLET_ID_LIST, GCONF_VALUE_STRING, list, &error);

	return 0;
}
