/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#ifdef WIN32
#include <afxwin.h>
#include <iostream>
#include "io.h"
#include "Dbghelp.h"
#endif

#include "Policy.h"
#include "PolicyDef.h"
#include "pm/PMPlugin.h"
#include <string>


#ifdef WIN32
//#include "afx.h"
#include <lm.h>
#pragma  comment(lib,"Netapi32.lib")
#else
#include <unistd.h>
#include <grp.h>
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
extern int Ini_WriteString(const char *Section, const char *Ident, const char *Value, const char *FileName);
extern int Ini_ReadString(const char *Section, const char *Ident, const char *Default, char *ret, const char *FileName);

const char* POLICY_INFO_PATH = "/etc/dcs/";
//char* POLICY_INFO_PATH = "/home/caoyi/policy/";
#endif

extern void DebugString(const char* format, ...);
Policy* Policy::m_pInstance=NULL;

Policy::Policy()
{
	Init();
}

Policy::~Policy()
{
	UnInit();
	if ( m_pInstance != NULL)
	{
		delete m_pInstance;
		m_pInstance = NULL;
	}

}

Policy* Policy::Instance()
{
	if (m_pInstance==NULL)
		m_pInstance = new Policy();

	return m_pInstance;
}

#ifdef WIN32
int Policy::LoadPolicy()
{
	int ret=0;
	DCS_UserGroup userGroup;
	int moduleId;
	int opId;
	DCS_Policy_Access _access_;

	int nTmp;
	int policy_num=0;



	CString file_str(m_file);
	if ( _access(m_file,0) != -1)// file exist
	{
		nTmp = GetPrivateProfileInt(_T("Global"),_T("Default"),-1,file_str);
		if ( nTmp ==  -1)
			return -1;
		m_defaultAccess = (DCS_Policy_Access)nTmp;
		//SetDefaultPolicy((DCS_Policy_Access)nTmp);

		policy_num = GetPrivateProfileInt(_T("Global"),_T("PolicyNum"),-1,file_str);
		if (policy_num == -1)
			return -1;

		for (int i=1;i<=policy_num;i++)
		{
			CString label;
			label.Format(_T("Policy%d"),i);

			nTmp = GetPrivateProfileInt(label,_T("UserGroup"),-1,file_str);
			if (nTmp == -1)
				continue;
			userGroup = (DCS_UserGroup)nTmp;

			moduleId = GetPrivateProfileInt(label,_T("ModuleID"),-1,file_str);
			if (moduleId == -1)
				continue;

			opId = GetPrivateProfileInt(label,_T("OpID"),-1,file_str);
			if (opId == -1)
				continue;

			nTmp = GetPrivateProfileInt(label,_T("Access"),-1,file_str);
			if (nTmp == -1)
				continue;
			_access_ = (DCS_Policy_Access)nTmp;

			SetPolicy(userGroup,moduleId,opId,_access_);
		}

	}
	else
	{
		FILE* file;
		if ( (file = fopen(m_file, "w+")) != NULL )	
		{

			if ( WritePrivateProfileString(_T("Global"),_T("Default"),_T("0"),file_str) ==0 )//default policy is allowed
			{
				fclose(file);
				return -1;
			}
			if (WritePrivateProfileString(_T("Global"),_T("PolicyNum"),_T("0"),file_str) ==0 )
			{
				fclose(file);
				return -1;
			}

			fclose(file);
		}
		else
			return -1;
	}

	return 0;
}

#else
int Policy::LoadPolicy()
{
	int ret=0;
	DCS_UserGroup userGroup;
	int moduleId;
	int opId;
	DCS_Policy_Access _access_;

	//char nTmp[MAX_PATH];
	int policy_num=0;
	if (access(m_file,0) == 0)// file exist
	{
		char str_tmp[MAX_PATH];
		memset(str_tmp,0,MAX_PATH);
		
		if (Ini_ReadString("Global","Default","",str_tmp,m_file))
			return -1;
		if (!strcmp(str_tmp,"0"))
			m_defaultAccess = DCS_POLICY_ALLOWED;
		else if (!strcmp(str_tmp,"1"))
			m_defaultAccess = DCS_POLICY_REJECTED;
		else {
			m_defaultAccess = DCS_POLICY_REJECTED;
			return -1;
		}
		
		memset(str_tmp,0,MAX_PATH);
		
		if (Ini_ReadString("Global","PolicyNum","",str_tmp,m_file))
			return -1;
		
		if ( !strcmp(str_tmp,""))
			return -1;
		
		policy_num = atoi(str_tmp);

		for (int i=1;i<=policy_num;i++)
		{
			char label[MAX_PATH];
			
			memset(label,0,MAX_PATH);
			memset(str_tmp,0,MAX_PATH);
			sprintf(label,"Policy%d",i);
			if (Ini_ReadString(label,"UserGroup","",str_tmp,m_file))
				return -1;

			if ( !strcmp(str_tmp,""))
			{
				continue;
			}
			userGroup = (DCS_UserGroup) atoi(str_tmp);


			memset(str_tmp,0,MAX_PATH);

			if (Ini_ReadString(label,"ModuleID","",str_tmp,m_file))
				return -1;
			if ( !strcmp(str_tmp,""))
			{
				continue;
			}
			moduleId = atoi(str_tmp);
	
			memset(str_tmp,0,MAX_PATH);
			if (Ini_ReadString(label,"OpID","",str_tmp,m_file))
				return -1;
			if ( !strcmp(str_tmp,""))
			{
				continue;
			}
			opId = atoi(str_tmp);

			memset(str_tmp,0,MAX_PATH);
			if (Ini_ReadString(label,"Access","",str_tmp,m_file))
				return -1;
			if ( !strcmp(str_tmp,""))
			{
				continue;
			}
			_access_ = (DCS_Policy_Access)atoi(str_tmp);

			SetPolicy(userGroup,moduleId,opId,_access_);
		}

		ret=0;
	}
	else
	{
		//int fd;
		FILE* file;
		if ( (file = fopen(m_file, "w+")) != NULL )	
		{
			if ( Ini_WriteString("Global","Default","0",m_file) > 0 )//default policy is allowed
			{
				fclose(file);
				return -1;
			}
			if (Ini_WriteString("Global","PolicyNum","0",m_file) > 0 )
			{
				fclose(file);
				return -1;
			}

			ret = 0;
		}
		else
			ret = -1;

		fclose(file);
	}

//	if (SavePolicy())
//		ret = -1;

	return ret;
}
#endif

int Policy::Init()
{
	memset(m_file,0,MAX_PATH);
	m_policies.clear();
#ifdef WIN32
	HKEY hKey;
	DWORD len = MAX_PATH;

	LONG ret_key = RegOpenKey(HKEY_LOCAL_MACHINE,_T("software\\intel\\dcs"),&hKey);// _T
	BYTE* byte_file = new BYTE[MAX_PATH];
	LONG ret_value = RegQueryValueEx(hKey,_T("DCSPath"),NULL,NULL,byte_file,&len);

	if ( ret_key == ERROR_SUCCESS && ret_value == ERROR_SUCCESS )
	{

			for (int i=0,j=0;i<(int)len && j<(int)len;j++,i+=2)
			{
				m_file[j]=(char)byte_file[i];
			}

			strcat(m_file,"\\policy.cfg");
			RegCloseKey(hKey);

	}
	else
	{
		char* defaultPath = "C:\\Program Files\\Intel\\Device Control Service\\dcs\\";//ShGetFolderPath try catch
		
		if (_access(defaultPath,0) == -1 ) //dir not exist
		{
			MakeSureDirectoryPathExists(defaultPath);
		}
		strcpy(m_file,defaultPath);
		strcat(m_file,"policy.cfg");
	}

#else
	if (access(POLICY_INFO_PATH,F_OK) < 0) // dir not exist
	{	
		DebugString("policy dir not exist \n");/////
		int fd;
		/*if ( (fd = open(POLICY_INFO_PATH,O_CREAT | O_DIRECTORY)) != 0) //create dir
		{
			printf("create dir failed \n");/////
			return -1;
		}*/
		if ( (fd = mkdir(POLICY_INFO_PATH,0)) != 0) //create dir
		{
			DebugString("create policy dir failed \n");/////
			return -1;
		}
	}

	strcpy(m_file,POLICY_INFO_PATH);
	strcat(m_file,"policy.cfg");
#endif	

	m_defaultAccess = DCS_POLICY_ALLOWED;

	LoadPolicy();
	SetPolicy(DCS_STUDENT_GROUP,DCS_POLICY,POLICY_SET,DCS_POLICY_REJECTED);
	SetPolicy(DCS_STUDENT_GROUP,DCS_POLICY,POLICY_REMOVE,DCS_POLICY_REJECTED);
	SetPolicy(DCS_STUDENT_GROUP,DCS_POLICY,POLICY_SET_DEFAULT,DCS_POLICY_REJECTED);
	SetPolicy(DCS_STUDENT_GROUP,DCS_POLICY,POLICY_SAVE,DCS_POLICY_REJECTED);

	SetPolicy(DCS_PARENT_GROUP,DCS_POLICY,POLICY_SET,DCS_POLICY_REJECTED);
	SetPolicy(DCS_PARENT_GROUP,DCS_POLICY,POLICY_REMOVE,DCS_POLICY_REJECTED);
	SetPolicy(DCS_PARENT_GROUP,DCS_POLICY,POLICY_SET_DEFAULT,DCS_POLICY_REJECTED);
	SetPolicy(DCS_PARENT_GROUP,DCS_POLICY,POLICY_SAVE,DCS_POLICY_REJECTED);

/*	SetPolicy(DCS_STUDENT_GROUP,DCS_POWER_MANAGER,PM_ADD_SCHEME,DCS_POLICY_REJECTED);
	SetPolicy(DCS_STUDENT_GROUP,DCS_POWER_MANAGER,PM_APPLY_SCHEME,DCS_POLICY_REJECTED);
	SetPolicy(DCS_STUDENT_GROUP,DCS_POWER_MANAGER,PM_EDIT_SCHEME,DCS_POLICY_REJECTED);
	SetPolicy(DCS_STUDENT_GROUP,DCS_POWER_MANAGER,PM_DELETE_SCHEME,DCS_POLICY_REJECTED);
*/
	return 0;
}

int Policy::UnInit()
{
	m_policies.clear();
	return 0;
}

#ifdef WIN32
CString GetGroupName(DCS_UserID userID)
{
	//LPLOCALGROUP_USERS_INFO_0 pBuf = NULL;
	//DWORD dwLevel = 0;
	//DWORD dwFlags = LG_INCLUDE_INDIRECT ;
	//DWORD dwPrefMaxLen = MAX_PREFERRED_LENGTH;
	//DWORD dwEntriesRead = 0;
	//DWORD dwTotalEntries = 0;
	//NET_API_STATUS nStatus;

	//try {
	//	CString temp = userID;
	//	nStatus = NetUserGetLocalGroups(NULL,temp,dwLevel,dwFlags,(LPBYTE *) &pBuf,
	//		dwPrefMaxLen,&dwEntriesRead,&dwTotalEntries);
	//}catch (...)
	//{
	//	DebugString("NetUserGetLocalGroups Error...");
	//	return CString("");
	//}

	//CString ret("");
	//DWORD dwTotalCount = 0;
	//if (nStatus == NERR_Success)
	//{
	//	LPLOCALGROUP_USERS_INFO_0 pTmpBuf;
	//	DWORD i;


	//	if ((pTmpBuf = pBuf) != NULL)
	//	{
	//		for (i = 0; i < dwEntriesRead; i++)
	//		{
	//			if (pTmpBuf == NULL)
	//			{
	//				fprintf(stderr, "An access violation has occurred\n");
	//				break;
	//			}
	//			pTmpBuf++;
	//			dwTotalCount++;
	//		}
	//	}

	//	ret=(pBuf+dwTotalCount-1)->lgrui0_name;

	//}
	//else 
	//{

	//	ret = "DENIED";
	//}


	//if (pBuf != NULL)
	//	NetApiBufferFree(pBuf);

	//return ret;
    return CString("");
}
DCS_UserGroup Policy::GetUserGroup(DCS_UserID userId)
{
	DCS_UserGroup userGroup = DCS_STUDENT_GROUP;
	DCS_UserGroup cur_group;

	LPLOCALGROUP_USERS_INFO_0 pBuf = NULL;
	DWORD dwLevel = 0;
	DWORD dwFlags = LG_INCLUDE_INDIRECT ;
	DWORD dwPrefMaxLen = MAX_PREFERRED_LENGTH;
	DWORD dwEntriesRead = 0;
	DWORD dwTotalEntries = 0;
	NET_API_STATUS nStatus;

	try {
		CString temp = userId;
		nStatus = NetUserGetLocalGroups(NULL,temp,dwLevel,dwFlags,(LPBYTE *) &pBuf,
			dwPrefMaxLen,&dwEntriesRead,&dwTotalEntries);
	}catch (...)
	{
		DebugString("NetUserGetLocalGroups Error...");
		userGroup = DCS_STUDENT_GROUP; 
		return userGroup;
	}

	CString ret("");
	if (nStatus == NERR_Success)
	{
		LPLOCALGROUP_USERS_INFO_0 pTmpBuf;
		DWORD i;


		if ((pTmpBuf = pBuf) != NULL)
		{
			for (i = 0; i < dwEntriesRead; i++)
			{
				if (pTmpBuf == NULL)
				{
		            userGroup = DCS_STUDENT_GROUP; 
					break;
				}
            	
                ret=(pBuf+i)->lgrui0_name;

                if (ret == "Administrators")
                {
                    userGroup = DCS_ADMINISTRATOR_GROUP;
                    break;
                }
                else if (ret == "Power Users")
                {
                    cur_group = DCS_PARENT_GROUP;
                }
                else
                {
                    cur_group = DCS_STUDENT_GROUP;
                }

                if (userGroup > cur_group)
                    userGroup = cur_group;
			}
		}
	}
	else 
	{
        userGroup = DCS_STUDENT_GROUP; 
	}

	if (pBuf != NULL)
		NetApiBufferFree(pBuf);
    DebugString("user group = %d\n",userGroup);

	return userGroup;
}
#else
DCS_UserGroup Policy::GetUserGroup(DCS_UserID userId)
{
	struct group *pEntry;
	DCS_UserGroup userGroup;
	string groupName;
	struct passwd* pPasswd = getpwuid(userId);
	pEntry = getgrgid(pPasswd->pw_gid);

	groupName = pEntry->gr_name;
	if (groupName=="root")
	{
		userGroup = DCS_ADMINISTRATOR_GROUP;
		//	m_encryptID = DCS_ADMINISTRATOR_ENCRYPTION;
	}
	else if (groupName == "parent")
	{
		userGroup = DCS_PARENT_GROUP;
		//	m_encryptID = DCS_PARENT_ENCRYPTION;
	}
	else if (groupName == "student")
	{
		userGroup = DCS_STUDENT_GROUP;
		//	m_encryptID = DCS_STUDENT_ENCRYPTION;
	}
	else
	{
		userGroup = DCS_STUDENT_GROUP;
		//	m_encryptID = DCS_NO_ENCRYPTION;
	}
	m_userGroup = userGroup;
	return userGroup;
}
#endif 
DCS_Policy_Access Policy::CheckPolicy(DCS_UserID userId, int moduleId, int opId)
{
	return CheckPolicy(GetUserGroup(userId),  moduleId,  opId);
}

DCS_Policy_Access Policy::CheckPolicy(DCS_UserGroup userGroup, int moduleId, int opId)
{
	if ( userGroup != DCS_ADMINISTRATOR_GROUP 
		&& userGroup != DCS_PARENT_GROUP
		&& userGroup != DCS_STUDENT_GROUP)
		return DCS_POLICY_REJECTED;
	if (moduleId < 0 || moduleId >=MODULE_NUM)
		return DCS_POLICY_REJECTED;
	if (opId <0 )
		return DCS_POLICY_REJECTED;

    if ( userGroup == DCS_ADMINISTRATOR_GROUP)
	    return DCS_POLICY_ALLOWED;// ADMINISTRATOR always has any policy, no check

	Policy_Operation policyOp;
	policyOp.usergroup=userGroup;
	policyOp.moduleId=moduleId;
	policyOp.opId=opId;

	Operation_Policies::iterator iter;

	try {
	iter = m_policies.find(policyOp);
	if(iter != m_policies.end())
		return m_policies[policyOp];
	} catch (...) {
		DebugString("CheckPolicy exception!");
	}

	return m_defaultAccess; 
}

int Policy::SetPolicy(DCS_UserGroup userGroup, int moduleId, int opId, DCS_Policy_Access access)
{
	if ( userGroup != DCS_ADMINISTRATOR_GROUP 
		&& userGroup != DCS_PARENT_GROUP
		&& userGroup != DCS_STUDENT_GROUP)
		return -1;
	if (moduleId < 0 || moduleId >= MODULE_NUM)
		return -1;
	if (opId <0 )
		return -1;

    if ( userGroup == DCS_ADMINISTRATOR_GROUP)
	    return 0;  // Administrator always has any rights, no set policy

	Policy_Operation policyOp;
	policyOp.usergroup=userGroup;
	policyOp.moduleId=moduleId;
	policyOp.opId=opId;

	m_policies[policyOp]=access;

	return 0;

}

int Policy::GetPolicy(DCS_UserGroup userGroup, int moduleId, int opId, DCS_Policy_Access* access)
{
	if ( userGroup != DCS_ADMINISTRATOR_GROUP 
		&& userGroup != DCS_PARENT_GROUP
		&& userGroup != DCS_STUDENT_GROUP)
		return -1;
	if (moduleId < 0 || moduleId >= MODULE_NUM)
		return -1;
	if (opId <0 )
		return -1;

	if (access == NULL)
		return -1;

    if ( userGroup == DCS_ADMINISTRATOR_GROUP)
    {// Administrator always has any rights, no set policy
        *access= DCS_POLICY_ALLOWED;
        return 0;
    }
	Policy_Operation policyOp;
	policyOp.usergroup=userGroup;
	policyOp.moduleId=moduleId;
	policyOp.opId=opId;

	Operation_Policies::iterator iter;
	iter = m_policies.find(policyOp);
	if(iter != m_policies.end())
		*access=m_policies[policyOp];
	else
		*access=m_defaultAccess;

	return 0;
}

int Policy::RemovePolicy(DCS_UserGroup userGroup, int moduleId, int opId)
{
	if ( userGroup != DCS_ADMINISTRATOR_GROUP 
		&& userGroup != DCS_PARENT_GROUP
		&& userGroup != DCS_STUDENT_GROUP)
		return -1;
	if (moduleId < 0 || moduleId >= MODULE_NUM)
		return -1;
	if (opId <0 )
		return -1;

	Policy_Operation policyOp;
	policyOp.usergroup=userGroup;
	policyOp.moduleId=moduleId;
	policyOp.opId=opId;

	Operation_Policies::iterator iter;
	iter = m_policies.find(policyOp);
	if (iter != m_policies.end())	  // policy exist in table
	{
		m_policies.erase(iter);
	}

	return 0;
}

int Policy::SetDefaultPolicy(DCS_Policy_Access access)
{
	if (access != DCS_POLICY_ALLOWED && access !=DCS_POLICY_REJECTED)
		return -1;

	m_defaultAccess = access;

	return 0;
}

#ifdef WIN32
int Policy::SavePolicy()
{
	DCS_UserGroup userGroup;
	int moduleId;
	int opId;
	DCS_Policy_Access access;

	Policy_Operation policy_op;
	FILE* file;
	if ( (file = fopen(m_file, "w+")) != NULL )	
	{
		CString file_str = m_file;

		CString str;
		str.Format(_T("%d"),(int)m_defaultAccess);
		if (!WritePrivateProfileString(_T("Global"),_T("Default"),str,file_str))
		{
			fclose(file);
			return -1;
		}

		str=_T("");
		str.Format(_T("%d"),m_policies.size());
		if (!WritePrivateProfileString(_T("Global"),_T("PolicyNum"),str,file_str))
		{
			fclose(file);
			return -1;
		}

		int nTmp=0;
		Operation_Policies::iterator iter;
		for (iter=m_policies.begin();iter!=m_policies.end();iter++)
		{
			policy_op = iter->first;
			userGroup = policy_op.usergroup;
			moduleId  = policy_op.moduleId;
			opId      = policy_op.opId;
			access    = iter->second;
			CString label;
			nTmp++;
			label.Format(_T("Policy%d"),nTmp);

			CString str_tmp;
			str_tmp.Format(_T("%d"),(int)userGroup);
			if (!WritePrivateProfileString(label,_T("UserGroup"),str_tmp,file_str))
			{
				fclose(file);
				return -1;
			}

			str_tmp.Format(_T("%d"),moduleId);
			if (!WritePrivateProfileString(label,_T("ModuleID"),str_tmp,file_str))
			{
				fclose(file);
				return -1;
			}

			str_tmp.Format(_T("%d"),opId);
			if (!WritePrivateProfileString(label,_T("OpID"),str_tmp,file_str))
			{
				fclose(file);
				return -1;
			}

			str_tmp.Format(_T("%d"),(int)access);
			if (!WritePrivateProfileString(label,_T("Access"),str_tmp,file_str))
			{
				fclose(file);
				return -1;
			}

		}

		fclose(file);

	}
	else
	{
		return -1;
	}

	return 0;
}
#else
int Policy::SavePolicy()
{
	int ret;
	DCS_UserGroup userGroup;
	int moduleId;
	int opId;
	DCS_Policy_Access _access;
	Policy_Operation policy_op;
	//int fd;
	FILE* file;
	if ((file = fopen(m_file,"w+")) != NULL)
	{	
		char temp[100];
		sprintf(temp,"%d",(int)m_defaultAccess);
		if (Ini_WriteString("Global","Default",temp,m_file) > 0)
		{
			fclose(file);
			return -1;
		}

		sprintf(temp,"%d",m_policies.size());
		if (Ini_WriteString("Global","PolicyNum",temp,m_file) > 0)
		{
			fclose(file);
			return -1;
		}

		int nTmp=0;
		Operation_Policies::iterator iter;
		for (iter=m_policies.begin();iter!=m_policies.end();iter++)
		{
			policy_op = iter->first;
			userGroup = policy_op.usergroup;
			moduleId  = policy_op.moduleId;
			opId      = policy_op.opId;
			_access    = iter->second;

			char label[MAX_PATH];
			nTmp++;

			memset(label,0,MAX_PATH);
			sprintf(label,"Policy%d",nTmp);

			char str_tmp[MAX_PATH];
			memset(str_tmp,0,MAX_PATH);
			sprintf(str_tmp,"%d",(int)userGroup);

			if (Ini_WriteString(label,"UserGroup",str_tmp,m_file) > 0)
			{
				fclose(file);
				return -1;
			}

			memset(str_tmp,0,MAX_PATH);		
			sprintf(str_tmp,"%d",moduleId);

			if (Ini_WriteString(label,"ModuleID",str_tmp,m_file) > 0)
			{
				fclose(file);
				return -1;
			}


			memset(str_tmp,0,MAX_PATH);		
			sprintf(str_tmp,"%d",opId);
			if (Ini_WriteString(label,"OpID",str_tmp,m_file) > 0)
			{
				fclose(file);
				return -1;
			}

			memset(str_tmp,0,MAX_PATH);		
			sprintf(str_tmp,"%d",(int)_access);
			if (Ini_WriteString(label,"Access",str_tmp,m_file) > 0)
			{
				fclose(file);
				return -1;
			}
		}

		ret = 0;
	}
	else
	{
		fclose(file);
		return -1;
	}

	fclose(file);

	return 0;
}
#endif
