/*
 * Enhanced Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#ifndef MESHCOMMON_H_INCLUDED
#define MESHCOMMON_H_INCLUDED

#include <asm/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <unistd.h>				/* for close */
#include <linux/wireless.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <string.h>

#define ERROR_IOCTL_IP	   					0x2
#define ERROR_IOCTL_HOSTNAME 		0x4
//
//SET/GET CONVENTION :
// * ------------------
// * Simplistic summary :
// *	o even numbered ioctls are SET, restricted to root, and should not
// *      return arguments (get_args = 0).
// *	o odd numbered ioctls are GET, authorised to anybody, and should
// *      not expect any arguments (set_args = 0).
//
#define RT_PRIV_IOCTL					(SIOCIWFIRSTPRIV + 0x0E)
#define RTPRIV_IOCTL_SET				(SIOCIWFIRSTPRIV + 0x02)
#define RTPRIV_IOCTL_BBP				(SIOCIWFIRSTPRIV + 0x03)
#define RTPRIV_IOCTL_MAC				(SIOCIWFIRSTPRIV + 0x05)
#define RTPRIV_IOCTL_E2P				(SIOCIWFIRSTPRIV + 0x11)
#define RTPRIV_IOCTL_STATISTICS			(SIOCIWFIRSTPRIV + 0x09)
#define RTPRIV_IOCTL_GSITESURVEY		(SIOCIWFIRSTPRIV + 0x0D)

#define MAX_MESH_ID_LENGTH              32

#define OID_GET_SET_TOGGLE			0x8000

#define RT_QUERY_ATE_TXDONE_COUNT	0x0401
#define RT_QUERY_SIGNAL_CONTEXT		0x0402
#define RT_SET_APD_PID				(OID_GET_SET_TOGGLE + 0x0405)
#define RT_SET_DEL_MAC_ENTRY		(OID_GET_SET_TOGGLE + 0x0406)

//---------------------------------------------------------
// Mesh Extension
#define OID_802_11_MESH_SECURITY_INFO	0x0651
#define OID_802_11_MESH_ID				0x0652
#define OID_802_11_MESH_AUTO_LINK		0x0653
#define OID_802_11_MESH_LINK_STATUS		0x0654
#define OID_802_11_MESH_LIST			0x0655
#define OID_802_11_MESH_ROUTE_LIST		0x0656
#define OID_802_11_MESH_ADD_LINK		0x0657
#define OID_802_11_MESH_DEL_LINK		0x0658
#define OID_802_11_MESH_MAX_TX_RATE		0x0659
#define OID_802_11_MESH_CHANNEL			0x065A
#define OID_802_11_MESH_HOSTNAME	0x065B
#define OID_802_11_BSSID_LIST_SCAN                  0x0508
#define OID_802_11_BSSID_LIST              		    0x0609
#define OID_802_11_MESH_ONLY_MODE  0x065C

#define RT_OID_802_11_MESH_HOSTNAME		(OID_GET_SET_TOGGLE + OID_802_11_MESH_HOSTNAME)
#define RT_OID_802_11_MESH_SECURITY_INFO	(OID_GET_SET_TOGGLE + OID_802_11_MESH_SECURITY_INFO)
#define RT_OID_802_11_MESH_ID				(OID_GET_SET_TOGGLE + OID_802_11_MESH_ID)
#define RT_OID_802_11_MESH_AUTO_LINK		(OID_GET_SET_TOGGLE + OID_802_11_MESH_AUTO_LINK)
#define RT_OID_802_11_MESH_ADD_LINK			(OID_GET_SET_TOGGLE + OID_802_11_MESH_ADD_LINK)
#define RT_OID_802_11_MESH_DEL_LINK			(OID_GET_SET_TOGGLE + OID_802_11_MESH_DEL_LINK)
#define RT_OID_802_11_MESH_MAX_TX_RATE		(OID_GET_SET_TOGGLE + OID_802_11_MESH_MAX_TX_RATE)
#define RT_OID_802_11_MESH_CHANNEL			(OID_GET_SET_TOGGLE + OID_802_11_MESH_CHANNEL)
#define RT_OID_802_11_MESH_ONLY_MODE    (OID_GET_SET_TOGGLE + OID_802_11_MESH_ONLY_MODE)
#define RT_OID_802_11_BSSID_LIST_SCAN  (OID_GET_SET_TOGGLE + OID_802_11_BSSID_LIST_SCAN)
//---------------------------------------------------------

#ifndef 	TRUE
#define 	TRUE				1
#endif

#ifndef 	FALSE
#define 	FALSE				0
#endif

#define MAC_ADDR_LEN			6
#define ETH_LENGTH_OF_ADDRESS	6
#define MAX_LEN_OF_MAC_TABLE	64


//#define DEBUG
#undef DEBUG_PRINT
#ifdef DEBUG
#define DEBUG_PRINT(fmt, args... ) printf("meshutility: " fmt, ##args)
#else
#define DEBUG_PRINT(fmt, args... )
#endif

#define 			G_FREE(x)                   \
    do{                                         \
        if(x) {														\
					g_free(x);                        \
					x = NULL;											\
				}																\
    } while(0)
#define ERROR_SOCKET 							0x1

#define PACKED  __attribute__ ((packed))
//---------------------------------------------------------

// Mesh definition
#define MESH_MAX_LEN_OF_FORWARD_TABLE	48

//=================================================================================


//
// IEEE 802.11 Structures and definitions
//
// new types for Media Specific Indications
#define NDIS_802_11_LENGTH_SSID         32
#define NDIS_802_11_LENGTH_RATES        8
#define NDIS_802_11_LENGTH_RATES_EX     16


typedef unsigned char UCHAR;
typedef unsigned long ULONG;
typedef unsigned int UINT;
typedef unsigned long long ULONGLONG;
typedef unsigned short USHORT;
typedef long LONG;
typedef int DWORD;
typedef long long LONGLONG;

typedef union _LARGE_INTEGER{
    struct{
        DWORD LowPart;
        LONG HighPart;
    };
    LONGLONG QuadPart;
} LARGE_INTEGER;

typedef struct _Infrastructure Infra;
struct _Infrastructure
{
    UCHAR *mac;
    UCHAR *quality;
    int iquality;
    Infra *children;
};

typedef struct _Network Network;
struct _Network
{
    UCHAR *ip;
    UCHAR *mac;
    UCHAR* name;
    UCHAR* status;
    UCHAR* ifname;
    Infra *children;
};

typedef struct _Neighbor Neighbor;
struct _Neighbor
{
    UCHAR *mac;
    UCHAR *hostname;
    UCHAR  *strength;
    UCHAR *channel;
    UCHAR *status;
    int pbvalue;
    void * func;
    Neighbor *children;
};

#define SOCK_FAIL -1
#define BAD_PARAM -2


#endif // MESHCOMMON_H_INCLUDED
