/*
 * indicator-network
 * Copyright 2010-2012 Canonical Ltd.
 *
 * Authors:
 * Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 * Kalle Valo       <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "manager.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <locale.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <libindicator/indicator-service.h>

#include "marshal.h"
#include "service.h"
#include "dbus-shared-names.h"
#include "service-manager.h"
#include "network-menu.h"
#include "log.h"

static gboolean debug = FALSE;

static GOptionEntry entries[] = {
  { "debug", 'd', 0, G_OPTION_ARG_NONE, &debug, "Enable debug mode", NULL },
  { NULL }
};

/*
 * When the service interface starts to shutdown, we should follow it. -
 */
static void service_shutdown(IndicatorService *service, gpointer user_data)
{
  g_debug("indicator service shutdown");
  gtk_main_quit();
  return;
}

static void signal_handler(int signal)
{
  g_debug("signal %d received, terminating", signal);

  gtk_main_quit();
}

int main (int argc, char ** argv)
{
  Manager *self;
  struct sigaction sa;
  IndicatorService *service;
  GOptionContext *context;
  GError *error = NULL;

  gtk_init(&argc, &argv);

  log_init("indicator-network-service");

  setlocale (LC_ALL, "");
  bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
  textdomain (GETTEXT_PACKAGE);

  context = g_option_context_new("- backend for Network Menu");
  g_option_context_add_main_entries(context, entries, GETTEXT_PACKAGE);

  if (!g_option_context_parse(context, &argc, &argv, &error)) {
    g_print("option parsing failed: %s\n", error->message);
    g_option_context_free(context);
    return 1;
  }

  if (debug)
    log_set_debug(TRUE);

  self = manager_new();

  service = indicator_service_new_version(INDICATOR_NETWORK_DBUS_NAME,
										  INDICATOR_NETWORK_DBUS_VERSION);

  g_signal_connect(G_OBJECT(service),
		   INDICATOR_SERVICE_SIGNAL_SHUTDOWN,
		   G_CALLBACK(service_shutdown), self);

  memset(&sa, 0, sizeof(sa));
  sa.sa_handler = signal_handler;
  sigaction(SIGINT, &sa, NULL);
  sigaction(SIGTERM, &sa, NULL);

  gtk_main();

  stop_agent(self);
  g_object_unref(service);
  g_object_unref(self);
  self = NULL;



  g_option_context_free(context);

  return 0;
}
