/*
 * indicator-network 
 * Copyright 2010-2012 Canonical Ltd.
 *
 * Authors:
 * Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 * Kalle Valo       <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _MANAGER_H_
#define _MANAGER_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define TYPE_MANAGER manager_get_type()

#define MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MANAGER, Manager))

#define MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MANAGER, ManagerClass))

#define IS_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MANAGER))

#define IS_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MANAGER))

#define MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MANAGER, ManagerClass))

typedef struct {
  GObject parent;
} Manager;

typedef struct {
  GObjectClass parent_class;
} ManagerClass;

#define ICON_CONNECTED_WIRED		"nm-device-wired"
#define ICON_CONNECTED_WIFI_0		"nm-signal-0"
#define ICON_CONNECTED_WIFI_25		"nm-signal-25"
#define ICON_CONNECTED_WIFI_50		"nm-signal-50"
#define ICON_CONNECTED_WIFI_75		"nm-signal-75"
#define ICON_CONNECTED_WIFI_100		"nm-signal-100"
#define ICON_CONNECTED_WIFI		ICON_CONNECTED_WIFI_100
#define ICON_CONNECTED_BLUETOOTH	"bluetooth-active"
#define ICON_CONNECTED_DEFAULT		ICON_CONNECTED_WIRED
#define ICON_DISCONNECTED		"nm-no-connection"

#define ICON_NOTIFICATION_WIFI_FULL		"notification-network-wireless-full"
#define ICON_NOTIFICATION_WIFI_DISCONNECTED	"notification-network-wireless-disconnected"
#define ICON_NOTIFICATION_WIRED_CONNECTED	"notification-network-ethernet-connected"
#define ICON_NOTIFICATION_WIRED_DISCONNECTED	"notification-network-ethernet-disconnected"
#define ICON_NOTIFICATION_CELLULAR_CONNECTED	"notification-gsm-high"
#define ICON_NOTIFICATION_CELLULAR_DISCONNECTED	"notification-gsm-disconnected"

#define CONNECTING_ICON_STAGES 3
#define CONNECTING_ICON_STATES 11
#define MAX_ICON_NAME_LEN 30

#define ICON_TELEPHONY_SIGNAL_LEVEL_GREAT    "gsm-signal-full"
#define ICON_TELEPHONY_SIGNAL_LEVEL_GOOD     "gsm-signal-high"
#define ICON_TELEPHONY_SIGNAL_LEVEL_MODERATE "gsm-signal-medium"
#define ICON_TELEPHONY_SIGNAL_LEVEL_POOR     "gsm-signal-low"
#define ICON_TELEPHONY_SIGNAL_LEVEL_UNKNOWN  "gsm-signal-none"

#define ICON_MOBILE_2G "gsm-2g"
#define ICON_MOBILE_3G "gsm-3g"
#define ICON_MOBILE_4G "gsm-4g"

#define ICON_AIRPLANE_MODE "gsm-plane-mode"

typedef enum {
  MANAGER_STATE_UNKNOWN,
  MANAGER_STATE_OFFLINE,
  MANAGER_STATE_ONLINE,
} ManagerState;


#include "network-menu.h"
#include "service-manager.h"
#include "service.h"

#include "ui-proxy.h"

#include "android-service.h"

typedef enum {
  TECHNOLOGY_STATE_ENABLED,
  TECHOLOGY_STATE_CONNECTED,
  TECHNOLOGY_STATE_UNKNOWN,
  TECHNOLOGY_STATE_UNAVAILABLE,
  TECHNOLOGY_STATE_AVAILABLE,
  TECHNOLOGY_STATE_OFFLINE,
  TECHNOLOGY_STATE_CONNECTED,
} TechnologyState;

typedef enum {
  TECHNOLOGY_TYPE_WIFI,
} TechnologyType;


GType manager_get_type(void);

const gchar *manager_icon_name(Manager *self, AndroidNetworkType type, gint signal);
const gchar *manager_wifi_icon_name(gint signal);
gchar *manager_accessible_desc(AndroidNetworkType type, gint signal);
void manager_notify(Manager *self, const gchar *summary, const gchar *body,
		    const gchar *icon);
UIProxy *manager_get_ui(Manager *self);

ServiceManager *manager_get_service_manager(Manager *self);
AndroidService *manager_get_android_service(Manager *self);

void stop_agent(Manager *self);
void manager_set_debug_level(Manager *self, gint level);
void manager_request_scan(Manager *self);
Manager *manager_new(void);

#endif

