/*
 * Copyright (C) 2021 Intel Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __IA_CSS_ISA_PARAMETER_DEFS_H
#define __IA_CSS_ISA_PARAMETER_DEFS_H

#include "ia_css_isa_parameter_defs_dep.h"

#define IA_CSS_ISA_KERNEL_IS_PRIMARY_INL            (0)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_BLC_GLOBAL        (0)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_BLC_SENSOR_TYPE_0        (1)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_BLC_SENSOR_TYPE_1        (1)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_BLC_SENSOR_TYPE_2        (1)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_PCLN            (0)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_LSC_SENSOR_TYPE_0        (1)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_LSC_SENSOR_TYPE_1        (1)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_LSC_SENSOR_TYPE_2        (1)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_DPC            (1)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_IDS            (0)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_3A_STAT_AWB        (1)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_3A_STAT_AF        (1)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_3A_STAT_AE_CCM        (0)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_3A_STAT_AE        (1)

#define IA_CSS_ISA_NEEDS_SPATIAL_IN_INL            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_BLC_GLOBAL            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_BLC_SENSOR_TYPE_0        (1)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_BLC_SENSOR_TYPE_1        (1)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_BLC_SENSOR_TYPE_2        (1)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_PCLN            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_LSC_SENSOR_TYPE_0        (1)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_LSC_SENSOR_TYPE_1        (1)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_LSC_SENSOR_TYPE_2        (1)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_DPC            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_IDS            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_3A_STAT_AWB        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_3A_STAT_AF            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_3A_STAT_AE_CCM        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_3A_STAT_AE            (0)

#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_INL            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_BLC_GLOBAL        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_BLC_SENSOR_TYPE_0        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_BLC_SENSOR_TYPE_1        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_BLC_SENSOR_TYPE_2        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_PCLN            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_LSC_SENSOR_TYPE_0        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_LSC_SENSOR_TYPE_1        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_LSC_SENSOR_TYPE_2        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_DPC            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_IDS            (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_3A_STAT_AWB        (1)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_3A_STAT_AF        (1)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_3A_STAT_AE_CCM        (0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_3A_STAT_AE        (0)

#define IA_CSS_ISA_NEEDS_SLICED_IN_INL                (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_BLC_GLOBAL            (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_BLC_SENSOR_TYPE_0        (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_BLC_SENSOR_TYPE_1        (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_BLC_SENSOR_TYPE_2        (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_PCLN            (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_LSC_SENSOR_TYPE_0        (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_LSC_SENSOR_TYPE_1        (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_LSC_SENSOR_TYPE_2        (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_DPC                (1)
#define IA_CSS_ISA_NEEDS_SLICED_IN_IDS                (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_3A_STAT_AWB            (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_3A_STAT_AF            (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_3A_STAT_AE_CCM        (0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_3A_STAT_AE            (0)

#define IA_CSS_ISA_NEEDS_SLICED_OUT_INL            (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_BLC_GLOBAL            (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_BLC_SENSOR_TYPE_0        (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_BLC_SENSOR_TYPE_1        (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_BLC_SENSOR_TYPE_2        (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_PCLN            (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_LSC_SENSOR_TYPE_0        (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_LSC_SENSOR_TYPE_1        (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_LSC_SENSOR_TYPE_2        (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_DPC            (1)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_IDS            (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_3A_STAT_AWB        (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_3A_STAT_AF            (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_3A_STAT_AE_CCM        (0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_3A_STAT_AE            (0)

/* ==================== INL specs - START ==================== */
/* in addition to register bank, it has a 0x200 memory bank to store LUT, found in reg_descr.hsd */
#define IA_CSS_ISA_PARAMETER_TERMINAL_INL_SECTION_COUNT                        (2)
#define IA_CSS_ISA_PARAMETER_TERMINAL_INL_MAX_SIZE_SECTION_0                        (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_INL_DEST_OFFSET_SECTION_0                    (0x204)
#define IA_CSS_ISA_PARAMETER_TERMINAL_INL_MAX_SIZE_SECTION_1                        (0x204)
#define IA_CSS_ISA_PARAMETER_TERMINAL_INL_DEST_OFFSET_SECTION_1                    (0x0)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_INL_SECTION_COUNT                        (0)

/* Spatial Parameter Terminal In does not exist for INL */

/* Spatial Parameter Terminal Out does not exist for INL */

/* Sliced Parameter Terminal In does not exist for INL */

/* Sliced Parameter Terminal Out does not exist for INL */

#define IA_CSS_ISA_PROGRAM_TERMINAL_INL_SECTION_COUNT                            (0)
/* ==================== INL specs - END ==================== */

/* ==================== BLC_GLOBAL specs - START ==================== */
/* in addition to register bank, it has a 0xC00 memory bank to store LUT, found in reg_descr.hsd */
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_SECTION_COUNT                        (2)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_MAX_SIZE_SECTION_0                    (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_DEST_OFFSET_SECTION_0                    (0xC08)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_MAX_SIZE_SECTION_1                    (0x20)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_DEST_OFFSET_SECTION_1                    (0xC0C)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_BLC_GLOBAL_SECTION_COUNT                    (0)

/* Spatial Parameter Terminal In does not exist for BLC_GLOBAL */

/* Spatial Parameter Terminal Out does not exist for BLC_GLOBAL */

/* Sliced Parameter Terminal In does not exist for BLC_GLOBAL */

/* Sliced Parameter Terminal Out does not exist for BLC_GLOBAL */

#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_GLOBAL_SECTION_COUNT                        (0)
/* ==================== BLC_GLOBAL specs - END ==================== */

/* ==================== BLC_SENSOR_TYPE_0 specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_0_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0                (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0                (0xC08)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_BLC_SENSOR_TYPE_0_SECTION_COUNT                (0)

#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SECTION_COUNT            (4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_COMPUTE_UNITS_PER_ELEM        (8)

#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_PER_SLICE        (128)    /* HW limit for slice height calculation */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH    (8)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH    (64)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT    (8)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT    (64)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_0        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_0            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_0    (0x0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_0        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_1        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_1            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_1    (0x300)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_1        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_2        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_2            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_2    (0x600)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_2        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_3        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_3            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_3    (0x900)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_3        (0x100)

/* Spatial Parameter Terminal Out does not exist for BLC_SENSOR_TYPE_0 */

/* Sliced Parameter Terminal In does not exist for BLC_SENSOR_TYPE_0 */

/* Sliced Parameter Terminal Out does not exist for BLC_SENSOR_TYPE_0 */

#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_0_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0                (0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0                (0xC00)
/* ==================== BLC_SENSOR_TYPE_0 specs - END ==================== */

/* ==================== BLC_SENSOR_TYPE_1 specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_1_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0                (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0                (0xC08)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_BLC_SENSOR_TYPE_1_SECTION_COUNT                (0)

#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SECTION_COUNT            (4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_COMPUTE_UNITS_PER_ELEM        (2)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_PER_SLICE        (128)    /* HW limit for slice height calculation */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH    (8)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH    (64)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT    (8)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT    (64)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_0        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_0            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_0    (0x0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_0        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_1        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_1            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_1    (0x300)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_1        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_2        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_2            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_2    (0x600)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_2        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_3        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_3            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_3    (0x900)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_3        (0x100)

/* Spatial Parameter Terminal Out does not exist for BLC_SENSOR_TYPE_1 */

/* Sliced Parameter Terminal In does not exist for BLC_SENSOR_TYPE_1 */

/* Sliced Parameter Terminal Out does not exist for BLC_SENSOR_TYPE_1 */

#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_1_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0                (0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0                (0xC00)
/* ==================== BLC_SENSOR_TYPE_1 specs - END ==================== */

/* ==================== BLC_SENSOR_TYPE_2 specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_2_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0                (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0                (0xC08)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_BLC_SENSOR_TYPE_2_SECTION_COUNT                (0)

#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SECTION_COUNT            (8)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_COMPUTE_UNITS_PER_ELEM        (1)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_PER_SLICE        (32)    /* HW limit for slice height calculation */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH    (8)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH    (32)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT    (8)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT    (32)    /* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_0        (0x80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_0            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_0    (0x0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_0        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_1        (0x80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_1            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_1    (0x300)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_1        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_2        (0x80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_2            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_2    (0x600)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_2        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_3        (0x80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_3            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_3    (0x900)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_3        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_4        (0x80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_4            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_4    (0x80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_4        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_5        (0x80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_5            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_5    (0x380)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_5        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_6        (0x80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_6            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_6    (0x680)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_6        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_7        (0x80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_7            (0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_7    (0x980)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_7        (0x100)

/* Spatial Parameter Terminal Out does not exist for BLC_SENSOR_TYPE_2 */

/* Sliced Parameter Terminal In does not exist for BLC_SENSOR_TYPE_2 */

/* Sliced Parameter Terminal Out does not exist for BLC_SENSOR_TYPE_2 */

#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_2_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0                (0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0                (0xC00)
/* ==================== BLC_SENSOR_TYPE_2 specs - END ==================== */

/* ==================== PCLN specs - START ==================== */
/* in addition to register bank, it has a 0x800 memory bank to store LUT, found in reg_descr.hsd */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_SECTION_COUNT                        (2)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_MAX_SIZE_SECTION_0                        (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_DEST_OFFSET_SECTION_0                    (0x820)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_MAX_SIZE_SECTION_1                        (0x820)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_DEST_OFFSET_SECTION_1                    (0x0)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PCLN_SECTION_COUNT                        (0)

/* Spatial Parameter Terminal In does not exist for PCLN */

/* Spatial Parameter Terminal Out does not exist for PCLN */

/* Sliced Parameter Terminal In does not exist for PCLN */

/* Sliced Parameter Terminal Out does not exist for PCLN */

#define IA_CSS_ISA_PROGRAM_TERMINAL_PCLN_SECTION_COUNT                            (0)
/* ==================== PCLN specs - END ==================== */

/* ==================== LSC_SENSOR_TYPE_0 specs - START ==================== */
/* in addition to register bank, it has a 0xC00 memory bank to store LUT, found in reg_descr.hsd */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_0_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0                (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0                (0xC08)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_0_SECTION_COUNT                (0)

/* Spatial Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_0 */

/* Sliced Parameter Terminal In does not exist for LSC_SENSOR_TYPE_0 */

/* Sliced Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_0 */

#define IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_0_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0                (0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0                (0xC00)
/* ==================== LSC_SENSOR_TYPE_0 specs - END ==================== */

/* ==================== LSC_SENSOR_TYPE_1 specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_1_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0                (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0                (0xC08)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_1_SECTION_COUNT                (0)

/* Spatial Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_1 */

/* Sliced Parameter Terminal In does not exist for LSC_SENSOR_TYPE_1 */

/* Sliced Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_1 */

#define IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_1_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0                (0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0                (0xC00)
/* ==================== LSC_SENSOR_TYPE_1 specs - END ==================== */

/* ==================== LSC_SENSOR_TYPE_2 specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_2_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0                (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0                (0xC08)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_2_SECTION_COUNT                (0)

/* Spatial Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_2 */

/* Sliced Parameter Terminal In does not exist for LSC_SENSOR_TYPE_2 */

/* Sliced Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_2 */

#define IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_2_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0                (0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0                (0xC00)
/* ==================== LSC_SENSOR_TYPE_2 specs - END ==================== */

/* ==================== BNR specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_SECTION_COUNT            (2)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_MAX_SIZE_SECTION_0    (0x2C)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_DEST_OFFSET_SECTION_0    (0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_MAX_SIZE_SECTION_1    (0xA4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_DEST_OFFSET_SECTION_1    (0x34)

#define IA_CSS_ISA_PROGRAM_TERMINAL_BNR_SECTION_COUNT            (1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BNR_MAX_SIZE_SECTION_0        (0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BNR_DEST_OFFSET_SECTION_0    (0x2C)
/* ==================== BNR specs - END ==================== */

/* ==================== ISA_DM specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_ISA_DEMOSAIC_SECTION_COUNT            (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_ISA_DEMOSAIC_MAX_SIZE_SECTION_0        (0x2C)
#define IA_CSS_ISA_PARAMETER_TERMINAL_ISA_DEMOSAIC_DEST_OFFSET_SECTION_0    (0x0)

/* ==================== ISA_DM specs - END ==================== */

/* ==================== IDS specs - START ==================== */
/* IDS is HW revision dependent */
/* ==================== IDS specs - END ==================== */

/* ==================== 3A_STAT_AWB specs - START ==================== */
/* AWB parameter properties are in the platform specific ia_css_parameter_defs_dep.h file */
/* ==================== 3A_STAT_AWB specs - END ==================== */

/* ==================== 3A_STAT_AF specs - START ==================== */
/* in addition to register bank, it has a 0x400 memory bank to store output, found in reg_descr.hsd */
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AF_SECTION_COUNT                        (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AF_MAX_SIZE_SECTION_0                    (0x88)
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AF_DEST_OFFSET_SECTION_0                    (0x40C)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SECTION_COUNT                    (0)

/* Spatial Parameter Terminal In does not exist for 3A_STAT_AF */

#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SECTION_COUNT                (2)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_COMPUTE_UNITS_PER_ELEM            (1)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_COMPUTE_UNITS_PER_SLICE        (32)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH        (16)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH        (32)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT        (16)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT        (32)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_SLICE_SIZE_SECTION_0            (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_ELEM_SIZE_SECTION_0            (0x8)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SLICE_0_DEST_OFFSET_SECTION_0        (0x0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_NEXT_SLICE_OFFSET_SECTION_0        (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_SLICE_SIZE_SECTION_1            (0x100)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_ELEM_SIZE_SECTION_1            (0x8)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SLICE_0_DEST_OFFSET_SECTION_1        (0x200)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_NEXT_SLICE_OFFSET_SECTION_1        (0x100)

/* Sliced Parameter Terminal In does not exist for 3A_STAT_AF */

/* Sliced Parameter Terminal Out does not exist for 3A_STAT_AF */

#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AF_SECTION_COUNT                        (1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AF_MAX_SIZE_SECTION_0                    (0xC)
#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AF_DEST_OFFSET_SECTION_0                    (0x400)
/* ==================== 3A_STAT_AF specs - END ==================== */

/* ==================== 3A_STAT_AE_CCM specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_CCM_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_CCM_MAX_SIZE_SECTION_0                (0x7C)
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_CCM_DEST_OFFSET_SECTION_0                (0x0)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AE_CCM_SECTION_COUNT                    (0)

/* Spatial Parameter Terminal In does not exist for 3A_STAT_AE_CCM */

/* Spatial Parameter Terminal Out does not exist for 3A_STAT_AE_CCM */

/* Sliced Parameter Terminal In does not exist for 3A_STAT_AE_CCM */

/* Sliced Parameter Terminal Out does not exist for 3A_STAT_AE_CCM */

#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_CCM_SECTION_COUNT                    (0)
/* ==================== 3A_STAT_AE_CCM specs - END ==================== */

/* ==================== 3A_STAT_AE specs - START ==================== */
/* in addition to register bank, it has a 0x180 memory bank to store LUT and a 0x2000 memory bank to store output,
   found in reg_descr.hsd */
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_SECTION_COUNT                        (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_MAX_SIZE_SECTION_0                    (0xC)
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_DEST_OFFSET_SECTION_0                    (0x18C)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AE_SECTION_COUNT                    (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AE_MAX_SIZE_SECTION_0                (0x2000)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AE_DEST_OFFSET_SECTION_0                (0x200)

/* Spatial Parameter Terminal In does not exist for 3A_STAT_AE */

/* Spatial Parameter Terminal Out does not exist for 3A_STAT_AE */

/* Sliced Parameter Terminal In does not exist for 3A_STAT_AE */

/* Sliced Parameter Terminal Out does not exist for 3A_STAT_AE */

#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_SECTION_COUNT                        (2)
#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_MAX_SIZE_SECTION_0                    (0xC)
#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_DEST_OFFSET_SECTION_0                    (0x180)
#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_MAX_SIZE_SECTION_1                    (0x180)
#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_DEST_OFFSET_SECTION_1                    (0x0)
/* ==================== 3A_STAT_AE specs - END ==================== */

/* TODO: REMOVE BACKWARD COMPATIBILITY */
#define IA_CSS_ISYS_PARAMETER_TERMINAL_INL_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_INL_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_INL_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_INL_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_INL_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_INL_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_INL_MAX_SIZE_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_INL_MAX_SIZE_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_INL_DEST_OFFSET_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_INL_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_INL_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_INL_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_INL_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_INL_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_GLOBAL_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_GLOBAL_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_GLOBAL_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_GLOBAL_MAX_SIZE_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_MAX_SIZE_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_GLOBAL_DEST_OFFSET_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_GLOBAL_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_BLC_GLOBAL_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_BLC_GLOBAL_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_GLOBAL_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_BLC_GLOBAL_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_0_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_0_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_BLC_SENSOR_TYPE_0_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_BLC_SENSOR_TYPE_0_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SECTION_COUNT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_COMPUTE_UNITS_PER_ELEM IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_COMPUTE_UNITS_PER_ELEM
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_PER_SLICE IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_PER_SLICE
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_3
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_0_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_0_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_1_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_1_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_BLC_SENSOR_TYPE_1_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_BLC_SENSOR_TYPE_1_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SECTION_COUNT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_COMPUTE_UNITS_PER_ELEM IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_COMPUTE_UNITS_PER_ELEM
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_PER_SLICE IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_PER_SLICE
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_3
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_1_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_1_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_2_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_2_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_BLC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_BLC_SENSOR_TYPE_2_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_BLC_SENSOR_TYPE_2_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SECTION_COUNT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_COMPUTE_UNITS_PER_ELEM IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_COMPUTE_UNITS_PER_ELEM
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_PER_SLICE IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_PER_SLICE
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_2 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_2
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_3 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_3
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_4 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_4
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_4 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_4
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_4 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_4
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_4 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_4
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_5 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_5
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_5 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_5
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_5 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_5
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_5 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_5
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_6 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_6
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_6 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_6
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_6 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_6
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_6 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_6
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_7 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_7
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_7 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_7
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_7 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_7
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_7 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_BLC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_7
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_2_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_2_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_BLC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_PCLN_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_PCLN_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_PCLN_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_PCLN_MAX_SIZE_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_MAX_SIZE_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_PCLN_DEST_OFFSET_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_PCLN_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_PCLN_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PCLN_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_PCLN_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_PCLN_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_0_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_0_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_0_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_0_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_SECTION_COUNT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_COMPUTE_UNITS_PER_ELEM IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_COMPUTE_UNITS_PER_ELEM
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_PER_SLICE IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_PER_SLICE
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_0_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_0_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_0_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_1_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_1_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_1_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_1_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_SECTION_COUNT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_COMPUTE_UNITS_PER_ELEM IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_COMPUTE_UNITS_PER_ELEM
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_PER_SLICE IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_PER_SLICE
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_1_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_1_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_1_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_1_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_2_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_2_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_LSC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_2_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_2_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_SECTION_COUNT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_COMPUTE_UNITS_PER_ELEM IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_COMPUTE_UNITS_PER_ELEM
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_PER_SLICE IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_PER_SLICE
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_2_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_2_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_2_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_LSC_SENSOR_TYPE_2_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AWB_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AWB_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AWB_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AWB_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AWB_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AWB_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_SECTION_COUNT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_COMPUTE_UNITS_PER_ELEM IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_COMPUTE_UNITS_PER_ELEM
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_COMPUTE_UNITS_PER_SLICE IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_COMPUTE_UNITS_PER_SLICE
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_ELEM_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_ELEM_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_SLICE_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_MAX_SLICE_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_ELEM_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_ELEM_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_SLICE_0_DEST_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_SLICE_0_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_NEXT_SLICE_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_NEXT_SLICE_OFFSET_SECTION_1
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AWB_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AWB_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AWB_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AWB_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AWB_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AWB_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AF_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AF_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AF_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AF_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AF_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AF_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SECTION_COUNT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SECTION_COUNT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_COMPUTE_UNITS_PER_ELEM IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_COMPUTE_UNITS_PER_ELEM
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_COMPUTE_UNITS_PER_SLICE IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_COMPUTE_UNITS_PER_SLICE
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_ELEM_SIZE_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_ELEM_SIZE_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_SLICE_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_MAX_SLICE_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_ELEM_SIZE_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_ELEM_SIZE_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SLICE_0_DEST_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_SLICE_0_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_NEXT_SLICE_OFFSET_SECTION_1 IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_3A_STAT_AF_NEXT_SLICE_OFFSET_SECTION_1
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AF_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AF_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AF_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AF_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AF_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AF_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AE_CCM_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_CCM_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AE_CCM_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_CCM_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AE_CCM_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_CCM_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_3A_STAT_AE_CCM_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AE_CCM_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AE_CCM_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_CCM_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AE_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AE_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_3A_STAT_AE_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AE_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_3A_STAT_AE_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AE_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_3A_STAT_AE_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AE_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_3A_STAT_AE_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AE_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AE_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AE_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AE_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AE_MAX_SIZE_SECTION_1 IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_MAX_SIZE_SECTION_1
#define IA_CSS_ISYS_PROGRAM_TERMINAL_3A_STAT_AE_DEST_OFFSET_SECTION_1 IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AE_DEST_OFFSET_SECTION_1

#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_INL IA_CSS_ISA_KERNEL_IS_PRIMARY_INL
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_BLC_GLOBAL IA_CSS_ISA_KERNEL_IS_PRIMARY_BLC_GLOBAL
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_BLC_SENSOR_TYPE_0 IA_CSS_ISA_KERNEL_IS_PRIMARY_BLC_SENSOR_TYPE_0
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_BLC_SENSOR_TYPE_1 IA_CSS_ISA_KERNEL_IS_PRIMARY_BLC_SENSOR_TYPE_1
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_BLC_SENSOR_TYPE_2 IA_CSS_ISA_KERNEL_IS_PRIMARY_BLC_SENSOR_TYPE_2
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_PCLN IA_CSS_ISA_KERNEL_IS_PRIMARY_PCLN
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_LSC_SENSOR_TYPE_0 IA_CSS_ISA_KERNEL_IS_PRIMARY_LSC_SENSOR_TYPE_0
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_LSC_SENSOR_TYPE_1 IA_CSS_ISA_KERNEL_IS_PRIMARY_LSC_SENSOR_TYPE_1
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_LSC_SENSOR_TYPE_2 IA_CSS_ISA_KERNEL_IS_PRIMARY_LSC_SENSOR_TYPE_2
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_DPC IA_CSS_ISA_KERNEL_IS_PRIMARY_DPC
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_IDS IA_CSS_ISA_KERNEL_IS_PRIMARY_IDS
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_3A_STAT_AWB IA_CSS_ISA_KERNEL_IS_PRIMARY_3A_STAT_AWB
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_3A_STAT_AF IA_CSS_ISA_KERNEL_IS_PRIMARY_3A_STAT_AF
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_3A_STAT_AE_CCM IA_CSS_ISA_KERNEL_IS_PRIMARY_3A_STAT_AE_CCM
#define IA_CSS_ISYS_KERNEL_IS_PRIMARY_3A_STAT_AE IA_CSS_ISA_KERNEL_IS_PRIMARY_3A_STAT_AE
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_INL IA_CSS_ISA_NEEDS_SPATIAL_IN_INL
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_BLC_GLOBAL IA_CSS_ISA_NEEDS_SPATIAL_IN_BLC_GLOBAL
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_BLC_SENSOR_TYPE_0 IA_CSS_ISA_NEEDS_SPATIAL_IN_BLC_SENSOR_TYPE_0
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_BLC_SENSOR_TYPE_1 IA_CSS_ISA_NEEDS_SPATIAL_IN_BLC_SENSOR_TYPE_1
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_BLC_SENSOR_TYPE_2 IA_CSS_ISA_NEEDS_SPATIAL_IN_BLC_SENSOR_TYPE_2
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_PCLN IA_CSS_ISA_NEEDS_SPATIAL_IN_PCLN
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_LSC_SENSOR_TYPE_0 IA_CSS_ISA_NEEDS_SPATIAL_IN_LSC_SENSOR_TYPE_0
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_LSC_SENSOR_TYPE_1 IA_CSS_ISA_NEEDS_SPATIAL_IN_LSC_SENSOR_TYPE_1
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_LSC_SENSOR_TYPE_2 IA_CSS_ISA_NEEDS_SPATIAL_IN_LSC_SENSOR_TYPE_2
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_DPC IA_CSS_ISA_NEEDS_SPATIAL_IN_DPC
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_IDS IA_CSS_ISA_NEEDS_SPATIAL_IN_IDS
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_3A_STAT_AWB IA_CSS_ISA_NEEDS_SPATIAL_IN_3A_STAT_AWB
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_3A_STAT_AF IA_CSS_ISA_NEEDS_SPATIAL_IN_3A_STAT_AF
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_3A_STAT_AE_CCM IA_CSS_ISA_NEEDS_SPATIAL_IN_3A_STAT_AE_CCM
#define IA_CSS_ISYS_NEEDS_SPATIAL_IN_3A_STAT_AE IA_CSS_ISA_NEEDS_SPATIAL_IN_3A_STAT_AE
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_INL IA_CSS_ISA_NEEDS_SPATIAL_OUT_INL
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_BLC_GLOBAL IA_CSS_ISA_NEEDS_SPATIAL_OUT_BLC_GLOBAL
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_BLC_SENSOR_TYPE_0 IA_CSS_ISA_NEEDS_SPATIAL_OUT_BLC_SENSOR_TYPE_0
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_BLC_SENSOR_TYPE_1 IA_CSS_ISA_NEEDS_SPATIAL_OUT_BLC_SENSOR_TYPE_1
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_BLC_SENSOR_TYPE_2 IA_CSS_ISA_NEEDS_SPATIAL_OUT_BLC_SENSOR_TYPE_2
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_PCLN IA_CSS_ISA_NEEDS_SPATIAL_OUT_PCLN
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_LSC_SENSOR_TYPE_0 IA_CSS_ISA_NEEDS_SPATIAL_OUT_LSC_SENSOR_TYPE_0
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_LSC_SENSOR_TYPE_1 IA_CSS_ISA_NEEDS_SPATIAL_OUT_LSC_SENSOR_TYPE_1
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_LSC_SENSOR_TYPE_2 IA_CSS_ISA_NEEDS_SPATIAL_OUT_LSC_SENSOR_TYPE_2
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_DPC IA_CSS_ISA_NEEDS_SPATIAL_OUT_DPC
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_IDS IA_CSS_ISA_NEEDS_SPATIAL_OUT_IDS
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_3A_STAT_AWB IA_CSS_ISA_NEEDS_SPATIAL_OUT_3A_STAT_AWB
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_3A_STAT_AF IA_CSS_ISA_NEEDS_SPATIAL_OUT_3A_STAT_AF
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_3A_STAT_AE_CCM IA_CSS_ISA_NEEDS_SPATIAL_OUT_3A_STAT_AE_CCM
#define IA_CSS_ISYS_NEEDS_SPATIAL_OUT_3A_STAT_AE IA_CSS_ISA_NEEDS_SPATIAL_OUT_3A_STAT_AE
#define IA_CSS_ISYS_NEEDS_SLICED_IN_INL IA_CSS_ISA_NEEDS_SLICED_IN_INL
#define IA_CSS_ISYS_NEEDS_SLICED_IN_BLC_GLOBAL IA_CSS_ISA_NEEDS_SLICED_IN_BLC_GLOBAL
#define IA_CSS_ISYS_NEEDS_SLICED_IN_BLC_SENSOR_TYPE_0 IA_CSS_ISA_NEEDS_SLICED_IN_BLC_SENSOR_TYPE_0
#define IA_CSS_ISYS_NEEDS_SLICED_IN_BLC_SENSOR_TYPE_1 IA_CSS_ISA_NEEDS_SLICED_IN_BLC_SENSOR_TYPE_1
#define IA_CSS_ISYS_NEEDS_SLICED_IN_BLC_SENSOR_TYPE_2 IA_CSS_ISA_NEEDS_SLICED_IN_BLC_SENSOR_TYPE_2
#define IA_CSS_ISYS_NEEDS_SLICED_IN_PCLN IA_CSS_ISA_NEEDS_SLICED_IN_PCLN
#define IA_CSS_ISYS_NEEDS_SLICED_IN_LSC_SENSOR_TYPE_0 IA_CSS_ISA_NEEDS_SLICED_IN_LSC_SENSOR_TYPE_0
#define IA_CSS_ISYS_NEEDS_SLICED_IN_LSC_SENSOR_TYPE_1 IA_CSS_ISA_NEEDS_SLICED_IN_LSC_SENSOR_TYPE_1
#define IA_CSS_ISYS_NEEDS_SLICED_IN_LSC_SENSOR_TYPE_2 IA_CSS_ISA_NEEDS_SLICED_IN_LSC_SENSOR_TYPE_2
#define IA_CSS_ISYS_NEEDS_SLICED_IN_DPC IA_CSS_ISA_NEEDS_SLICED_IN_DPC
#define IA_CSS_ISYS_NEEDS_SLICED_IN_IDS IA_CSS_ISA_NEEDS_SLICED_IN_IDS
#define IA_CSS_ISYS_NEEDS_SLICED_IN_3A_STAT_AWB IA_CSS_ISA_NEEDS_SLICED_IN_3A_STAT_AWB
#define IA_CSS_ISYS_NEEDS_SLICED_IN_3A_STAT_AF IA_CSS_ISA_NEEDS_SLICED_IN_3A_STAT_AF
#define IA_CSS_ISYS_NEEDS_SLICED_IN_3A_STAT_AE_CCM IA_CSS_ISA_NEEDS_SLICED_IN_3A_STAT_AE_CCM
#define IA_CSS_ISYS_NEEDS_SLICED_IN_3A_STAT_AE IA_CSS_ISA_NEEDS_SLICED_IN_3A_STAT_AE
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_INL IA_CSS_ISA_NEEDS_SLICED_OUT_INL
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_BLC_GLOBAL IA_CSS_ISA_NEEDS_SLICED_OUT_BLC_GLOBAL
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_BLC_SENSOR_TYPE_0 IA_CSS_ISA_NEEDS_SLICED_OUT_BLC_SENSOR_TYPE_0
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_BLC_SENSOR_TYPE_1 IA_CSS_ISA_NEEDS_SLICED_OUT_BLC_SENSOR_TYPE_1
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_BLC_SENSOR_TYPE_2 IA_CSS_ISA_NEEDS_SLICED_OUT_BLC_SENSOR_TYPE_2
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_PCLN IA_CSS_ISA_NEEDS_SLICED_OUT_PCLN
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_LSC_SENSOR_TYPE_0 IA_CSS_ISA_NEEDS_SLICED_OUT_LSC_SENSOR_TYPE_0
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_LSC_SENSOR_TYPE_1 IA_CSS_ISA_NEEDS_SLICED_OUT_LSC_SENSOR_TYPE_1
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_LSC_SENSOR_TYPE_2 IA_CSS_ISA_NEEDS_SLICED_OUT_LSC_SENSOR_TYPE_2
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_DPC IA_CSS_ISA_NEEDS_SLICED_OUT_DPC
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_IDS IA_CSS_ISA_NEEDS_SLICED_OUT_IDS
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_3A_STAT_AWB IA_CSS_ISA_NEEDS_SLICED_OUT_3A_STAT_AWB
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_3A_STAT_AF IA_CSS_ISA_NEEDS_SLICED_OUT_3A_STAT_AF
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_3A_STAT_AE_CCM IA_CSS_ISA_NEEDS_SLICED_OUT_3A_STAT_AE_CCM
#define IA_CSS_ISYS_NEEDS_SLICED_OUT_3A_STAT_AE IA_CSS_ISA_NEEDS_SLICED_OUT_3A_STAT_AE
/* END OF TODO */

#endif /* __IA_CSS_ISA_PARAMETER_DEFS_H */
