/*
 * Copyright (C) 2012 The Android Open Source Project
 * Copyright (C) 2015-2018 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * !! Do not reference this file directly !!
 *
 * It is logically a part of camera_metadata_base.cpp.  It is broken out for
 * ease of maintaining the tag info.
 *
 * Array assignments are done using specified-index syntax to keep things in
 * sync with icamera_metadata_tags.h
 */

/**
 * ! Do not edit this file directly !
 *
 * Generated automatically from icamera_metadata_tag_info.mako
 */

const char *icamera_metadata_section_names[CAMERA_SECTION_COUNT] = {
    "camera.ae", /* [CAMERA_AE] */
    "camera.awb", /* [CAMERA_AWB] */
    "camera.af", /* [CAMERA_AF] */
    "camera.control", /* [CAMERA_CONTROL] */
    "camera.demosaic", /* [CAMERA_DEMOSAIC] */
    "camera.edge", /* [CAMERA_EDGE] */
    "camera.flash", /* [CAMERA_FLASH] */
    "camera.flash.info", /* [CAMERA_FLASH_INFO] */
    "camera.hotPixel", /* [CAMERA_HOT_PIXEL] */
    "camera.jpeg", /* [CAMERA_JPEG] */
    "camera.lens", /* [CAMERA_LENS] */
    "camera.lens.info", /* [CAMERA_LENS_INFO] */
    "camera.noiseReduction", /* [CAMERA_NOISE_REDUCTION] */
    "camera.request", /* [CAMERA_REQUEST] */
    "camera.scaler", /* [CAMERA_SCALER] */
    "camera.sensor", /* [CAMERA_SENSOR] */
    "camera.sensor.info", /* [CAMERA_SENSOR_INFO] */
    "camera.shading", /* [CAMERA_SHADING] */
    "camera.statistics", /* [CAMERA_STATISTICS] */
    "camera.statistics.info", /* [CAMERA_STATISTICS_INFO] */
    "camera.tonemap", /* [CAMERA_TONEMAP] */
    "camera.led", /* [CAMERA_LED] */
    "camera.info", /* [CAMERA_INFO] */
    "camera.blackLevel", /* [CAMERA_BLACK_LEVEL] */
    "camera.sync", /* [CAMERA_SYNC] */
    "camera.reprocess", /* [CAMERA_REPROCESS] */
    "intel.info", /* [INTEL_INFO] */
    "intel.control", /* [INTEL_CONTROL] */
    "intel.control_isp", /* [INTEL_CONTROL_ISP] */
};

unsigned int icamera_metadata_section_bounds[CAMERA_SECTION_COUNT][2] = {
    /* [CAMERA_AE] */
    { CAMERA_AE_START, CAMERA_AE_END },
    /* [CAMERA_AWB] */
    { CAMERA_AWB_START, CAMERA_AWB_END },
    /* [CAMERA_AF] */
    { CAMERA_AF_START, CAMERA_AF_END },
    /* [CAMERA_CONTROL] */
    { CAMERA_CONTROL_START, CAMERA_CONTROL_END },
    /* [CAMERA_DEMOSAIC] */
    { CAMERA_DEMOSAIC_START, CAMERA_DEMOSAIC_END },
    /* [CAMERA_EDGE] */
    { CAMERA_EDGE_START, CAMERA_EDGE_END },
    /* [CAMERA_FLASH] */
    { CAMERA_FLASH_START, CAMERA_FLASH_END },
    /* [CAMERA_FLASH_INFO] */
    { CAMERA_FLASH_INFO_START, CAMERA_FLASH_INFO_END },
    /* [CAMERA_HOT_PIXEL] */
    { CAMERA_HOT_PIXEL_START, CAMERA_HOT_PIXEL_END },
    /* [CAMERA_JPEG] */
    { CAMERA_JPEG_START, CAMERA_JPEG_END },
    /* [CAMERA_LENS] */
    { CAMERA_LENS_START, CAMERA_LENS_END },
    /* [CAMERA_LENS_INFO] */
    { CAMERA_LENS_INFO_START, CAMERA_LENS_INFO_END },
    /* [CAMERA_NOISE_REDUCTION] */
    { CAMERA_NOISE_REDUCTION_START, CAMERA_NOISE_REDUCTION_END },
    /* [CAMERA_REQUEST] */
    { CAMERA_REQUEST_START, CAMERA_REQUEST_END },
    /* [CAMERA_SCALER] */
    { CAMERA_SCALER_START, CAMERA_SCALER_END },
    /* [CAMERA_SENSOR] */
    { CAMERA_SENSOR_START, CAMERA_SENSOR_END },
    /* [CAMERA_SENSOR_INFO] */
    { CAMERA_SENSOR_INFO_START, CAMERA_SENSOR_INFO_END },
    /* [CAMERA_SHADING] */
    { CAMERA_SHADING_START, CAMERA_SHADING_END },
    /* [CAMERA_STATISTICS] */
    { CAMERA_STATISTICS_START, CAMERA_STATISTICS_END },
    /* [CAMERA_STATISTICS_INFO] */
    { CAMERA_STATISTICS_INFO_START, CAMERA_STATISTICS_INFO_END },
    /* [CAMERA_TONEMAP] */
    { CAMERA_TONEMAP_START, CAMERA_TONEMAP_END },
    /* [CAMERA_LED] */
    { CAMERA_LED_START, CAMERA_LED_END },
    /* [CAMERA_INFO] */
    { CAMERA_INFO_START, CAMERA_INFO_END },
    /* [CAMERA_BLACK_LEVEL] */
    { CAMERA_BLACK_LEVEL_START, CAMERA_BLACK_LEVEL_END },
    /* [CAMERA_SYNC] */
    { CAMERA_SYNC_START, CAMERA_SYNC_END },
    /* [CAMERA_REPROCESS] */
    { CAMERA_REPROCESS_START, CAMERA_REPROCESS_END },
    /* [INTEL_INFO] */
    { INTEL_INFO_START, INTEL_INFO_END },
    /* [INTEL_CONTROL] */
    { INTEL_CONTROL_START, INTEL_CONTROL_END },
    /* [INTEL_CONTROL_ISP] */
    { INTEL_CONTROL_ISP_START, INTEL_CONTROL_ISP_END },
};

static tag_info_t camera_ae[CAMERA_AE_END -
        CAMERA_AE_START] = {
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "lock",                          ICAMERA_TYPE_BYTE   },
    { "regions",                       ICAMERA_TYPE_INT32  },
    { "antibandingMode",               ICAMERA_TYPE_BYTE   },
    { "compensation",                  ICAMERA_TYPE_INT32  },
    { "targetFpsRange",                ICAMERA_TYPE_FLOAT  },
    { "precaptureTrigger",             ICAMERA_TYPE_BYTE   },
    { "state",                         ICAMERA_TYPE_BYTE   },
    { "availableModes",                ICAMERA_TYPE_BYTE   },
    { "availableAntibandingModes",     ICAMERA_TYPE_BYTE   },
    { "compensationStep",              ICAMERA_TYPE_RATIONAL
                        },
    { "compensationRange",             ICAMERA_TYPE_INT32  },
    { "availableTargetFpsRanges",      ICAMERA_TYPE_FLOAT  },
    { "lockAvailable",                 ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_awb[CAMERA_AWB_END -
        CAMERA_AWB_START] = {
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "colorTransform",                ICAMERA_TYPE_FLOAT  },
    { "colorGains",                    ICAMERA_TYPE_FLOAT  },
    { "lock",                          ICAMERA_TYPE_BYTE   },
    { "regions",                       ICAMERA_TYPE_INT32  },
    { "cctRange",                      ICAMERA_TYPE_INT32  },
    { "gains",                         ICAMERA_TYPE_INT32  },
    { "gainShift",                     ICAMERA_TYPE_INT32  },
    { "whitePoint",                    ICAMERA_TYPE_INT32  },
    { "convergeSpeed",                 ICAMERA_TYPE_BYTE   },
    { "convergeSpeedMode",             ICAMERA_TYPE_BYTE   },
    { "state",                         ICAMERA_TYPE_BYTE   },
    { "result",                        ICAMERA_TYPE_BYTE   },
    { "availableModes",                ICAMERA_TYPE_BYTE   },
    { "lockAvailable",                 ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_af[CAMERA_AF_END -
        CAMERA_AF_START] = {
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "regions",                       ICAMERA_TYPE_INT32  },
    { "trigger",                       ICAMERA_TYPE_BYTE   },
    { "availableModes",                ICAMERA_TYPE_BYTE   },
    { "state",                         ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_control[CAMERA_CONTROL_END -
        CAMERA_CONTROL_START] = {
    { "captureintent",                 ICAMERA_TYPE_BYTE   },
    { "effectMode",                    ICAMERA_TYPE_BYTE   },
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "sceneMode",                     ICAMERA_TYPE_BYTE   },
    { "videoStabilizationMode",        ICAMERA_TYPE_BYTE   },
    { "availableEffects",              ICAMERA_TYPE_BYTE   },
    { "availableModes",                ICAMERA_TYPE_BYTE   },
    { "availableSceneModes",           ICAMERA_TYPE_BYTE   },
    { "availableVideoStabilizationModes",
                                        ICAMERA_TYPE_BYTE   },
    { "maxRegions",                    ICAMERA_TYPE_INT32  },
    { "sceneModeOverrides",            ICAMERA_TYPE_BYTE   },
    { "availableHighSpeedVideoConfigurations",
                                        ICAMERA_TYPE_INT32  },
};

static tag_info_t camera_demosaic[CAMERA_DEMOSAIC_END -
        CAMERA_DEMOSAIC_START] = {
    { "mode",                          ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_edge[CAMERA_EDGE_END -
        CAMERA_EDGE_START] = {
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "strength",                      ICAMERA_TYPE_BYTE   },
    { "availableEdgeModes",            ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_flash[CAMERA_FLASH_END -
        CAMERA_FLASH_START] = {
    { "firingPower",                   ICAMERA_TYPE_BYTE   },
    { "firingTime",                    ICAMERA_TYPE_INT64  },
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "colorTemperature",              ICAMERA_TYPE_BYTE   },
    { "maxEnergy",                     ICAMERA_TYPE_BYTE   },
    { "state",                         ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_flash_info[CAMERA_FLASH_INFO_END -
        CAMERA_FLASH_INFO_START] = {
    { "available",                     ICAMERA_TYPE_BYTE   },
    { "chargeDuration",                ICAMERA_TYPE_INT64  },
};

static tag_info_t camera_hot_pixel[CAMERA_HOT_PIXEL_END -
        CAMERA_HOT_PIXEL_START] = {
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "availableHotPixelModes",        ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_jpeg[CAMERA_JPEG_END -
        CAMERA_JPEG_START] = {
    { "gpsCoordinates",                ICAMERA_TYPE_DOUBLE },
    { "gpsProcessingMethod",           ICAMERA_TYPE_BYTE   },
    { "gpsTimestamp",                  ICAMERA_TYPE_INT64  },
    { "orientation",                   ICAMERA_TYPE_INT32  },
    { "quality",                       ICAMERA_TYPE_BYTE   },
    { "thumbnailQuality",              ICAMERA_TYPE_BYTE   },
    { "thumbnailSize",                 ICAMERA_TYPE_INT32  },
    { "availableThumbnailSizes",       ICAMERA_TYPE_INT32  },
    { "maxSize",                       ICAMERA_TYPE_INT32  },
    { "size",                          ICAMERA_TYPE_INT32  },
};

static tag_info_t camera_lens[CAMERA_LENS_END -
        CAMERA_LENS_START] = {
    { "aperture",                      ICAMERA_TYPE_FLOAT  },
    { "filterDensity",                 ICAMERA_TYPE_FLOAT  },
    { "focalLength",                   ICAMERA_TYPE_FLOAT  },
    { "focusDistance",                 ICAMERA_TYPE_FLOAT  },
    { "opticalStabilizationMode",      ICAMERA_TYPE_BYTE   },
    { "facing",                        ICAMERA_TYPE_BYTE   },
    { "focusRange",                    ICAMERA_TYPE_FLOAT  },
    { "state",                         ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_lens_info[CAMERA_LENS_INFO_END -
        CAMERA_LENS_INFO_START] = {
    { "availableApertures",            ICAMERA_TYPE_FLOAT  },
    { "availableFilterDensities",      ICAMERA_TYPE_FLOAT  },
    { "availableFocalLengths",         ICAMERA_TYPE_FLOAT  },
    { "availableOpticalStabilization", ICAMERA_TYPE_BYTE   },
    { "hyperfocalDistance",            ICAMERA_TYPE_FLOAT  },
    { "minimumFocusDistance",          ICAMERA_TYPE_FLOAT  },
    { "shadingMapSize",                ICAMERA_TYPE_INT32  },
    { "focusDistanceCalibration",      ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_noise_reduction[CAMERA_NOISE_REDUCTION_END -
        CAMERA_NOISE_REDUCTION_START] = {
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "strength",                      ICAMERA_TYPE_BYTE   },
    { "availableNoiseReductionModes",  ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_request[CAMERA_REQUEST_END -
        CAMERA_REQUEST_START] = {
    { "id",                            ICAMERA_TYPE_INT32  },
    { "metadataMode",                  ICAMERA_TYPE_BYTE   },
    { "maxNumOutputStreams",           ICAMERA_TYPE_INT32  },
    { "maxNumInputStreams",            ICAMERA_TYPE_INT32  },
    { "pipelineDepth",                 ICAMERA_TYPE_BYTE   },
    { "pipelineMaxDepth",              ICAMERA_TYPE_BYTE   },
    { "partialResultCount",            ICAMERA_TYPE_INT32  },
    { "availableCapabilities",         ICAMERA_TYPE_BYTE   },
    { "availableRequestKeys",          ICAMERA_TYPE_INT32  },
    { "availableResultKeys",           ICAMERA_TYPE_INT32  },
    { "availableCharacteristicsKeys",  ICAMERA_TYPE_INT32  },
};

static tag_info_t camera_scaler[CAMERA_SCALER_END -
        CAMERA_SCALER_START] = {
    { "cropRegion",                    ICAMERA_TYPE_INT32  },
    { "availableJpegSizes",            ICAMERA_TYPE_INT32  },
    { "availableMaxDigitalZoom",       ICAMERA_TYPE_FLOAT  },
    { "availableInputOutputFormatsMap",
                                        ICAMERA_TYPE_INT32  },
    { "availableStreamConfigurations", ICAMERA_TYPE_INT32  },
    { "availableMinFrameDurations",    ICAMERA_TYPE_INT64  },
    { "availableStallDurations",       ICAMERA_TYPE_INT64  },
    { "croppingType",                  ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_sensor[CAMERA_SENSOR_END -
        CAMERA_SENSOR_START] = {
    { "exposureTime",                  ICAMERA_TYPE_INT64  },
    { "frameDuration",                 ICAMERA_TYPE_INT64  },
    { "sensitivity",                   ICAMERA_TYPE_INT32  },
    { "referenceIlluminant1",          ICAMERA_TYPE_BYTE   },
    { "referenceIlluminant2",          ICAMERA_TYPE_BYTE   },
    { "calibrationTransform1",         ICAMERA_TYPE_RATIONAL
                        },
    { "calibrationTransform2",         ICAMERA_TYPE_RATIONAL
                        },
    { "colorTransform1",               ICAMERA_TYPE_RATIONAL
                        },
    { "colorTransform2",               ICAMERA_TYPE_RATIONAL
                        },
    { "forwardMatrix1",                ICAMERA_TYPE_RATIONAL
                        },
    { "forwardMatrix2",                ICAMERA_TYPE_RATIONAL
                        },
    { "baseGainFactor",                ICAMERA_TYPE_RATIONAL
                        },
    { "blackLevelPattern",             ICAMERA_TYPE_INT32  },
    { "maxAnalogSensitivity",          ICAMERA_TYPE_INT32  },
    { "orientation",                   ICAMERA_TYPE_INT32  },
    { "profileHueSatMapDimensions",    ICAMERA_TYPE_INT32  },
    { "timestamp",                     ICAMERA_TYPE_INT64  },
    { "temperature",                   ICAMERA_TYPE_FLOAT  },
    { "neutralColorPoint",             ICAMERA_TYPE_RATIONAL
                        },
    { "noiseProfile",                  ICAMERA_TYPE_DOUBLE },
    { "profileHueSatMap",              ICAMERA_TYPE_FLOAT  },
    { "profileToneCurve",              ICAMERA_TYPE_FLOAT  },
    { "greenSplit",                    ICAMERA_TYPE_FLOAT  },
    { "testPatternData",               ICAMERA_TYPE_INT32  },
    { "testPatternMode",               ICAMERA_TYPE_INT32  },
    { "availableTestPatternModes",     ICAMERA_TYPE_INT32  },
    { "opaqueRawSize",                 ICAMERA_TYPE_INT32  },
    { "rollingShutterSkew",            ICAMERA_TYPE_INT64  },
};

static tag_info_t camera_sensor_info[CAMERA_SENSOR_INFO_END -
        CAMERA_SENSOR_INFO_START] = {
    { "activeArraySize",               ICAMERA_TYPE_INT32  },
    { "sensitivityRange",              ICAMERA_TYPE_INT32  },
    { "colorFilterArrangement",        ICAMERA_TYPE_BYTE   },
    { "exposureTimeRange",             ICAMERA_TYPE_INT64  },
    { "maxFrameDuration",              ICAMERA_TYPE_INT64  },
    { "physicalSize",                  ICAMERA_TYPE_FLOAT  },
    { "pixelArraySize",                ICAMERA_TYPE_INT32  },
    { "whiteLevel",                    ICAMERA_TYPE_INT32  },
    { "timestampSource",               ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_shading[CAMERA_SHADING_END -
        CAMERA_SHADING_START] = {
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "strength",                      ICAMERA_TYPE_BYTE   },
    { "availableModes",                ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_statistics[CAMERA_STATISTICS_END -
        CAMERA_STATISTICS_START] = {
    { "faceDetectMode",                ICAMERA_TYPE_BYTE   },
    { "histogramMode",                 ICAMERA_TYPE_BYTE   },
    { "sharpnessMapMode",              ICAMERA_TYPE_BYTE   },
    { "hotPixelMapMode",               ICAMERA_TYPE_BYTE   },
    { "faceIds",                       ICAMERA_TYPE_INT32  },
    { "faceLandmarks",                 ICAMERA_TYPE_INT32  },
    { "faceRectangles",                ICAMERA_TYPE_INT32  },
    { "faceScores",                    ICAMERA_TYPE_BYTE   },
    { "histogram",                     ICAMERA_TYPE_INT32  },
    { "sharpnessMap",                  ICAMERA_TYPE_INT32  },
    { "lensShadingCorrectionMap",      ICAMERA_TYPE_BYTE   },
    { "lensShadingMap",                ICAMERA_TYPE_FLOAT  },
    { "predictedColorGains",           ICAMERA_TYPE_FLOAT  },
    { "predictedColorTransform",       ICAMERA_TYPE_RATIONAL
                        },
    { "sceneFlicker",                  ICAMERA_TYPE_BYTE   },
    { "hotPixelMap",                   ICAMERA_TYPE_INT32  },
    { "lensShadingMapMode",            ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_statistics_info[CAMERA_STATISTICS_INFO_END -
        CAMERA_STATISTICS_INFO_START] = {
    { "availableFaceDetectModes",      ICAMERA_TYPE_BYTE   },
    { "histogramBucketCount",          ICAMERA_TYPE_INT32  },
    { "maxFaceCount",                  ICAMERA_TYPE_INT32  },
    { "maxHistogramCount",             ICAMERA_TYPE_INT32  },
    { "maxSharpnessMapValue",          ICAMERA_TYPE_INT32  },
    { "sharpnessMapSize",              ICAMERA_TYPE_INT32  },
    { "availableHotPixelMapModes",     ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_tonemap[CAMERA_TONEMAP_END -
        CAMERA_TONEMAP_START] = {
    { "curveBlue",                     ICAMERA_TYPE_FLOAT  },
    { "curveGreen",                    ICAMERA_TYPE_FLOAT  },
    { "curveRed",                      ICAMERA_TYPE_FLOAT  },
    { "mode",                          ICAMERA_TYPE_BYTE   },
    { "maxCurvePoints",                ICAMERA_TYPE_INT32  },
    { "availableToneMapModes",         ICAMERA_TYPE_BYTE   },
    { "gamma",                         ICAMERA_TYPE_FLOAT  },
    { "presetCurve",                   ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_led[CAMERA_LED_END -
        CAMERA_LED_START] = {
    { "transmit",                      ICAMERA_TYPE_BYTE   },
    { "availableLeds",                 ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_info[CAMERA_INFO_END -
        CAMERA_INFO_START] = {
    { "supportedHardwareLevel",        ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_black_level[CAMERA_BLACK_LEVEL_END -
        CAMERA_BLACK_LEVEL_START] = {
    { "lock",                          ICAMERA_TYPE_BYTE   },
};

static tag_info_t camera_sync[CAMERA_SYNC_END -
        CAMERA_SYNC_START] = {
    { "frameNumber",                   ICAMERA_TYPE_INT64  },
    { "maxLatency",                    ICAMERA_TYPE_INT32  },
};

static tag_info_t camera_reprocess[CAMERA_REPROCESS_END -
        CAMERA_REPROCESS_START] = {
    { "maxCaptureStall",               ICAMERA_TYPE_INT32  },
};

static tag_info_t intel_info[INTEL_INFO_END -
        INTEL_INFO_START] = {
    { "availableConfigurations",       ICAMERA_TYPE_INT32  },
    { "availableFeatures",             ICAMERA_TYPE_BYTE   },
    { "aeExposureTimeRange",           ICAMERA_TYPE_INT32  },
    { "aeGainRange",                   ICAMERA_TYPE_INT32  },
    { "wfov",                          ICAMERA_TYPE_BYTE   },
    { "sensorMountType",               ICAMERA_TYPE_BYTE   },
};

static tag_info_t intel_control[INTEL_CONTROL_END -
        INTEL_CONTROL_START] = {
    { "imageEnhancement",              ICAMERA_TYPE_INT32  },
    { "sensitivityGain",               ICAMERA_TYPE_FLOAT  },
    { "frameRate",                     ICAMERA_TYPE_FLOAT  },
    { "aeConvergeSpeed",               ICAMERA_TYPE_BYTE   },
    { "nrMode",                        ICAMERA_TYPE_BYTE   },
    { "nrLevel",                       ICAMERA_TYPE_INT32  },
    { "irisMode",                      ICAMERA_TYPE_BYTE   },
    { "aeDistributionPriority",        ICAMERA_TYPE_BYTE   },
    { "irisLevel",                     ICAMERA_TYPE_INT32  },
    { "wdrMode",                       ICAMERA_TYPE_BYTE   },
    { "wdrLevel",                      ICAMERA_TYPE_BYTE   },
    { "blcAreaMode",                   ICAMERA_TYPE_BYTE   },
    { "sceneMode",                     ICAMERA_TYPE_BYTE   },
    { "weightGridMode",                ICAMERA_TYPE_BYTE   },
    { "aeConvergeSpeedMode",           ICAMERA_TYPE_BYTE   },
    { "deinterlaceMode",               ICAMERA_TYPE_BYTE   },
    { "makernoteData",                 ICAMERA_TYPE_BYTE   },
    { "customAicParam",                ICAMERA_TYPE_BYTE   },
    { "makernoteMode",                 ICAMERA_TYPE_BYTE   },
    { "yuvColorRange",                 ICAMERA_TYPE_BYTE   },
    { "sensitivityGainRange",          ICAMERA_TYPE_FLOAT  },
    { "exposureTimeRange",             ICAMERA_TYPE_INT32  },
    { "fisheyeDewarpingMode",          ICAMERA_TYPE_BYTE   },
    { "ltmTuningData",                 ICAMERA_TYPE_BYTE   },
    { "digitalZoomRatio",              ICAMERA_TYPE_FLOAT  },
    { "ldcMode",                       ICAMERA_TYPE_BYTE   },
    { "rscMode",                       ICAMERA_TYPE_BYTE   },
    { "flipMode",                      ICAMERA_TYPE_BYTE   },
    { "monoDownscale",                 ICAMERA_TYPE_BYTE   },
    { "run3ACadence",                  ICAMERA_TYPE_INT32  },
    { "viewProjection",                ICAMERA_TYPE_BYTE   },
    { "viewRotation",                  ICAMERA_TYPE_BYTE   },
    { "viewFineAdjustments",           ICAMERA_TYPE_BYTE   },
    { "cameraRotation",                ICAMERA_TYPE_BYTE   },
    { "scalerCropRegion",              ICAMERA_TYPE_INT32  },
};

static tag_info_t intel_control_isp[INTEL_CONTROL_ISP_END -
        INTEL_CONTROL_ISP_START] = {
    { "supportedCtrlIds",              ICAMERA_TYPE_INT32  },
    { "enabledCtrlIds",                ICAMERA_TYPE_INT32  },
    { "wb_gains",                      ICAMERA_TYPE_BYTE   },
    { "color_correction_matrix",       ICAMERA_TYPE_BYTE   },
    { "advanced_color_correction_matrix",
                                        ICAMERA_TYPE_BYTE   },
    { "bxt_csc",                       ICAMERA_TYPE_BYTE   },
    { "bxt_demosaic",                  ICAMERA_TYPE_BYTE   },
    { "sc_iefd",                       ICAMERA_TYPE_BYTE   },
    { "see",                           ICAMERA_TYPE_BYTE   },
    { "bnlm",                          ICAMERA_TYPE_BYTE   },
    { "tnr5_21",                       ICAMERA_TYPE_BYTE   },
    { "xnr_dss",                       ICAMERA_TYPE_BYTE   },
    { "gamma_tone_map",                ICAMERA_TYPE_BYTE   },
    { "tnr5_22",                       ICAMERA_TYPE_BYTE   },
    { "tnr5_25",                       ICAMERA_TYPE_BYTE   },
};

tag_info_t *icamera_tag_info[CAMERA_SECTION_COUNT] = {
    camera_ae,
    camera_awb,
    camera_af,
    camera_control,
    camera_demosaic,
    camera_edge,
    camera_flash,
    camera_flash_info,
    camera_hot_pixel,
    camera_jpeg,
    camera_lens,
    camera_lens_info,
    camera_noise_reduction,
    camera_request,
    camera_scaler,
    camera_sensor,
    camera_sensor_info,
    camera_shading,
    camera_statistics,
    camera_statistics_info,
    camera_tonemap,
    camera_led,
    camera_info,
    camera_black_level,
    camera_sync,
    camera_reprocess,
    intel_info,
    intel_control,
    intel_control_isp,
};

int icamera_metadata_enum_snprint(uint32_t tag,
                                  int32_t value,
                                  char *dst,
                                  size_t size) {
    const char *msg = "error: not an enum";
    int ret = -1;

    switch(tag) {
        case CAMERA_AE_MODE: {
            switch (value) {
                case CAMERA_AE_MODE_MANUAL:
                    msg = "MANUAL";
                    ret = 0;
                    break;
                case CAMERA_AE_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AE_LOCK: {
            switch (value) {
                case CAMERA_AE_LOCK_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_AE_LOCK_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AE_REGIONS: {
            break;
        }
        case CAMERA_AE_ANTIBANDING_MODE: {
            switch (value) {
                case CAMERA_AE_ANTIBANDING_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case CAMERA_AE_ANTIBANDING_MODE_50HZ:
                    msg = "50HZ";
                    ret = 0;
                    break;
                case CAMERA_AE_ANTIBANDING_MODE_60HZ:
                    msg = "60HZ";
                    ret = 0;
                    break;
                case CAMERA_AE_ANTIBANDING_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AE_COMPENSATION: {
            break;
        }
        case CAMERA_AE_TARGET_FPS_RANGE: {
            break;
        }
        case CAMERA_AE_PRECAPTURE_TRIGGER: {
            switch (value) {
                case CAMERA_AE_PRECAPTURE_TRIGGER_IDLE:
                    msg = "IDLE";
                    ret = 0;
                    break;
                case CAMERA_AE_PRECAPTURE_TRIGGER_START:
                    msg = "START";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AE_STATE: {
            switch (value) {
                case CAMERA_AE_STATE_INACTIVE:
                    msg = "INACTIVE";
                    ret = 0;
                    break;
                case CAMERA_AE_STATE_SEARCHING:
                    msg = "SEARCHING";
                    ret = 0;
                    break;
                case CAMERA_AE_STATE_CONVERGED:
                    msg = "CONVERGED";
                    ret = 0;
                    break;
                case CAMERA_AE_STATE_LOCKED:
                    msg = "LOCKED";
                    ret = 0;
                    break;
                case CAMERA_AE_STATE_FLASH_REQUIRED:
                    msg = "FLASH_REQUIRED";
                    ret = 0;
                    break;
                case CAMERA_AE_STATE_PRECAPTURE:
                    msg = "PRECAPTURE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AE_AVAILABLE_MODES: {
            break;
        }
        case CAMERA_AE_AVAILABLE_ANTIBANDING_MODES: {
            break;
        }
        case CAMERA_AE_COMPENSATION_STEP: {
            break;
        }
        case CAMERA_AE_COMPENSATION_RANGE: {
            break;
        }
        case CAMERA_AE_AVAILABLE_TARGET_FPS_RANGES: {
            break;
        }
        case CAMERA_AE_LOCK_AVAILABLE: {
            switch (value) {
                case CAMERA_AE_LOCK_AVAILABLE_FALSE:
                    msg = "FALSE";
                    ret = 0;
                    break;
                case CAMERA_AE_LOCK_AVAILABLE_TRUE:
                    msg = "TRUE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_AWB_MODE: {
            switch (value) {
                case CAMERA_AWB_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_INCANDESCENT:
                    msg = "INCANDESCENT";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_FLUORESCENT:
                    msg = "FLUORESCENT";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_DAYLIGHT:
                    msg = "DAYLIGHT";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_FULL_OVERCAST:
                    msg = "FULL_OVERCAST";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_PARTLY_OVERCAST:
                    msg = "PARTLY_OVERCAST";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_SUNSET:
                    msg = "SUNSET";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_VIDEO_CONFERENCE:
                    msg = "VIDEO_CONFERENCE";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_MANUAL_CCT_RANGE:
                    msg = "MANUAL_CCT_RANGE";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_MANUAL_WHITE_POINT:
                    msg = "MANUAL_WHITE_POINT";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_MANUAL_GAIN:
                    msg = "MANUAL_GAIN";
                    ret = 0;
                    break;
                case CAMERA_AWB_MODE_MANUAL_COLOR_TRANSFORM:
                    msg = "MANUAL_COLOR_TRANSFORM";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AWB_COLOR_TRANSFORM: {
            break;
        }
        case CAMERA_AWB_COLOR_GAINS: {
            break;
        }
        case CAMERA_AWB_LOCK: {
            switch (value) {
                case CAMERA_AWB_LOCK_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_AWB_LOCK_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AWB_REGIONS: {
            break;
        }
        case CAMERA_AWB_CCT_RANGE: {
            break;
        }
        case CAMERA_AWB_GAINS: {
            break;
        }
        case CAMERA_AWB_GAIN_SHIFT: {
            break;
        }
        case CAMERA_AWB_WHITE_POINT: {
            break;
        }
        case CAMERA_AWB_CONVERGE_SPEED: {
            switch (value) {
                case CAMERA_AWB_CONVERGE_SPEED_NORMAL:
                    msg = "NORMAL";
                    ret = 0;
                    break;
                case CAMERA_AWB_CONVERGE_SPEED_MID:
                    msg = "MID";
                    ret = 0;
                    break;
                case CAMERA_AWB_CONVERGE_SPEED_LOW:
                    msg = "LOW";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AWB_CONVERGE_SPEED_MODE: {
            switch (value) {
                case CAMERA_AWB_CONVERGE_SPEED_MODE_HAL:
                    msg = "HAL";
                    ret = 0;
                    break;
                case CAMERA_AWB_CONVERGE_SPEED_MODE_AIQ:
                    msg = "AIQ";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AWB_STATE: {
            switch (value) {
                case CAMERA_AWB_STATE_INACTIVE:
                    msg = "INACTIVE";
                    ret = 0;
                    break;
                case CAMERA_AWB_STATE_SEARCHING:
                    msg = "SEARCHING";
                    ret = 0;
                    break;
                case CAMERA_AWB_STATE_CONVERGED:
                    msg = "CONVERGED";
                    ret = 0;
                    break;
                case CAMERA_AWB_STATE_LOCKED:
                    msg = "LOCKED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AWB_RESULT: {
            break;
        }
        case CAMERA_AWB_AVAILABLE_MODES: {
            break;
        }
        case CAMERA_AWB_LOCK_AVAILABLE: {
            switch (value) {
                case CAMERA_AWB_LOCK_AVAILABLE_FALSE:
                    msg = "FALSE";
                    ret = 0;
                    break;
                case CAMERA_AWB_LOCK_AVAILABLE_TRUE:
                    msg = "TRUE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_AF_MODE: {
            switch (value) {
                case CAMERA_AF_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_AF_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case CAMERA_AF_MODE_MACRO:
                    msg = "MACRO";
                    ret = 0;
                    break;
                case CAMERA_AF_MODE_CONTINUOUS_VIDEO:
                    msg = "CONTINUOUS_VIDEO";
                    ret = 0;
                    break;
                case CAMERA_AF_MODE_CONTINUOUS_PICTURE:
                    msg = "CONTINUOUS_PICTURE";
                    ret = 0;
                    break;
                case CAMERA_AF_MODE_EDOF:
                    msg = "EDOF";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AF_REGIONS: {
            break;
        }
        case CAMERA_AF_TRIGGER: {
            switch (value) {
                case CAMERA_AF_TRIGGER_IDLE:
                    msg = "IDLE";
                    ret = 0;
                    break;
                case CAMERA_AF_TRIGGER_START:
                    msg = "START";
                    ret = 0;
                    break;
                case CAMERA_AF_TRIGGER_CANCEL:
                    msg = "CANCEL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_AF_AVAILABLE_MODES: {
            break;
        }
        case CAMERA_AF_STATE: {
            switch (value) {
                case CAMERA_AF_STATE_INACTIVE:
                    msg = "INACTIVE";
                    ret = 0;
                    break;
                case CAMERA_AF_STATE_PASSIVE_SCAN:
                    msg = "PASSIVE_SCAN";
                    ret = 0;
                    break;
                case CAMERA_AF_STATE_PASSIVE_FOCUSED:
                    msg = "PASSIVE_FOCUSED";
                    ret = 0;
                    break;
                case CAMERA_AF_STATE_ACTIVE_SCAN:
                    msg = "ACTIVE_SCAN";
                    ret = 0;
                    break;
                case CAMERA_AF_STATE_FOCUSED_LOCKED:
                    msg = "FOCUSED_LOCKED";
                    ret = 0;
                    break;
                case CAMERA_AF_STATE_NOT_FOCUSED_LOCKED:
                    msg = "NOT_FOCUSED_LOCKED";
                    ret = 0;
                    break;
                case CAMERA_AF_STATE_PASSIVE_UNFOCUSED:
                    msg = "PASSIVE_UNFOCUSED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_CONTROL_CAPTUREINTENT: {
            switch (value) {
                case CAMERA_CONTROL_CAPTUREINTENT_CUSTOM:
                    msg = "CUSTOM";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_CAPTUREINTENT_PREVIEW:
                    msg = "PREVIEW";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_CAPTUREINTENT_STILL_CAPTURE:
                    msg = "STILL_CAPTURE";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_CAPTUREINTENT_VIDEO_RECORD:
                    msg = "VIDEO_RECORD";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_CAPTUREINTENT_VIDEO_SNAPSHOT:
                    msg = "VIDEO_SNAPSHOT";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_CAPTUREINTENT_ZERO_SHUTTER_LAG:
                    msg = "ZERO_SHUTTER_LAG";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_CAPTUREINTENT_MANUAL:
                    msg = "MANUAL";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_CAPTUREINTENT_MOTION_TRACKING:
                    msg = "MOTION_TRACKING";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_CONTROL_EFFECT_MODE: {
            switch (value) {
                case CAMERA_CONTROL_EFFECT_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_EFFECT_MODE_MONO:
                    msg = "MONO";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_EFFECT_MODE_NEGATIVE:
                    msg = "NEGATIVE";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_EFFECT_MODE_SOLARIZE:
                    msg = "SOLARIZE";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_EFFECT_MODE_SEPIA:
                    msg = "SEPIA";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_EFFECT_MODE_POSTERIZE:
                    msg = "POSTERIZE";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_EFFECT_MODE_WHITEBOARD:
                    msg = "WHITEBOARD";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_EFFECT_MODE_BLACKBOARD:
                    msg = "BLACKBOARD";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_EFFECT_MODE_AQUA:
                    msg = "AQUA";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_CONTROL_MODE: {
            switch (value) {
                case CAMERA_CONTROL_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_MODE_USE_SCENE_MODE:
                    msg = "USE_SCENE_MODE";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_MODE_OFF_KEEP_STATE:
                    msg = "OFF_KEEP_STATE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_CONTROL_SCENE_MODE: {
            switch (value) {
                case CAMERA_CONTROL_SCENE_MODE_DISABLED:
                    msg = "DISABLED";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_FACE_PRIORITY:
                    msg = "FACE_PRIORITY";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_ACTION:
                    msg = "ACTION";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_PORTRAIT:
                    msg = "PORTRAIT";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_LANDSCAPE:
                    msg = "LANDSCAPE";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_NIGHT:
                    msg = "NIGHT";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_NIGHT_PORTRAIT:
                    msg = "NIGHT_PORTRAIT";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_THEATRE:
                    msg = "THEATRE";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_BEACH:
                    msg = "BEACH";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_SNOW:
                    msg = "SNOW";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_SUNSET:
                    msg = "SUNSET";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_STEADYPHOTO:
                    msg = "STEADYPHOTO";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_FIREWORKS:
                    msg = "FIREWORKS";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_SPORTS:
                    msg = "SPORTS";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_PARTY:
                    msg = "PARTY";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_CANDLELIGHT:
                    msg = "CANDLELIGHT";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_BARCODE:
                    msg = "BARCODE";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_HIGH_SPEED_VIDEO:
                    msg = "HIGH_SPEED_VIDEO";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_SCENE_MODE_HDR:
                    msg = "HDR";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_CONTROL_VIDEO_STABILIZATION_MODE: {
            switch (value) {
                case CAMERA_CONTROL_VIDEO_STABILIZATION_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_CONTROL_VIDEO_STABILIZATION_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_CONTROL_AVAILABLE_EFFECTS: {
            break;
        }
        case CAMERA_CONTROL_AVAILABLE_MODES: {
            break;
        }
        case CAMERA_CONTROL_AVAILABLE_SCENE_MODES: {
            break;
        }
        case CAMERA_CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES: {
            break;
        }
        case CAMERA_CONTROL_MAX_REGIONS: {
            break;
        }
        case CAMERA_CONTROL_SCENE_MODE_OVERRIDES: {
            break;
        }
        case CAMERA_CONTROL_AVAILABLE_HIGH_SPEED_VIDEO_CONFIGURATIONS: {
            break;
        }

        case CAMERA_DEMOSAIC_MODE: {
            switch (value) {
                case CAMERA_DEMOSAIC_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case CAMERA_DEMOSAIC_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_EDGE_MODE: {
            switch (value) {
                case CAMERA_EDGE_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_EDGE_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case CAMERA_EDGE_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                case CAMERA_EDGE_MODE_ZERO_SHUTTER_LAG:
                    msg = "ZERO_SHUTTER_LAG";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_EDGE_STRENGTH: {
            break;
        }
        case CAMERA_EDGE_AVAILABLE_EDGE_MODES: {
            break;
        }

        case CAMERA_FLASH_FIRING_POWER: {
            break;
        }
        case CAMERA_FLASH_FIRING_TIME: {
            break;
        }
        case CAMERA_FLASH_MODE: {
            switch (value) {
                case CAMERA_FLASH_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_FLASH_MODE_SINGLE:
                    msg = "SINGLE";
                    ret = 0;
                    break;
                case CAMERA_FLASH_MODE_TORCH:
                    msg = "TORCH";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_FLASH_COLOR_TEMPERATURE: {
            break;
        }
        case CAMERA_FLASH_MAX_ENERGY: {
            break;
        }
        case CAMERA_FLASH_STATE: {
            switch (value) {
                case CAMERA_FLASH_STATE_UNAVAILABLE:
                    msg = "UNAVAILABLE";
                    ret = 0;
                    break;
                case CAMERA_FLASH_STATE_CHARGING:
                    msg = "CHARGING";
                    ret = 0;
                    break;
                case CAMERA_FLASH_STATE_READY:
                    msg = "READY";
                    ret = 0;
                    break;
                case CAMERA_FLASH_STATE_FIRED:
                    msg = "FIRED";
                    ret = 0;
                    break;
                case CAMERA_FLASH_STATE_PARTIAL:
                    msg = "PARTIAL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_FLASH_INFO_AVAILABLE: {
            switch (value) {
                case CAMERA_FLASH_INFO_AVAILABLE_FALSE:
                    msg = "FALSE";
                    ret = 0;
                    break;
                case CAMERA_FLASH_INFO_AVAILABLE_TRUE:
                    msg = "TRUE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_FLASH_INFO_CHARGE_DURATION: {
            break;
        }

        case CAMERA_HOT_PIXEL_MODE: {
            switch (value) {
                case CAMERA_HOT_PIXEL_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_HOT_PIXEL_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case CAMERA_HOT_PIXEL_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_HOT_PIXEL_AVAILABLE_HOT_PIXEL_MODES: {
            break;
        }

        case CAMERA_JPEG_GPS_COORDINATES: {
            break;
        }
        case CAMERA_JPEG_GPS_PROCESSING_METHOD: {
            break;
        }
        case CAMERA_JPEG_GPS_TIMESTAMP: {
            break;
        }
        case CAMERA_JPEG_ORIENTATION: {
            break;
        }
        case CAMERA_JPEG_QUALITY: {
            break;
        }
        case CAMERA_JPEG_THUMBNAIL_QUALITY: {
            break;
        }
        case CAMERA_JPEG_THUMBNAIL_SIZE: {
            break;
        }
        case CAMERA_JPEG_AVAILABLE_THUMBNAIL_SIZES: {
            break;
        }
        case CAMERA_JPEG_MAX_SIZE: {
            break;
        }
        case CAMERA_JPEG_SIZE: {
            break;
        }

        case CAMERA_LENS_APERTURE: {
            break;
        }
        case CAMERA_LENS_FILTER_DENSITY: {
            break;
        }
        case CAMERA_LENS_FOCAL_LENGTH: {
            break;
        }
        case CAMERA_LENS_FOCUS_DISTANCE: {
            break;
        }
        case CAMERA_LENS_OPTICAL_STABILIZATION_MODE: {
            switch (value) {
                case CAMERA_LENS_OPTICAL_STABILIZATION_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_LENS_OPTICAL_STABILIZATION_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_LENS_FACING: {
            switch (value) {
                case CAMERA_LENS_FACING_FRONT:
                    msg = "FRONT";
                    ret = 0;
                    break;
                case CAMERA_LENS_FACING_BACK:
                    msg = "BACK";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_LENS_FOCUS_RANGE: {
            break;
        }
        case CAMERA_LENS_STATE: {
            switch (value) {
                case CAMERA_LENS_STATE_STATIONARY:
                    msg = "STATIONARY";
                    ret = 0;
                    break;
                case CAMERA_LENS_STATE_MOVING:
                    msg = "MOVING";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_LENS_INFO_AVAILABLE_APERTURES: {
            break;
        }
        case CAMERA_LENS_INFO_AVAILABLE_FILTER_DENSITIES: {
            break;
        }
        case CAMERA_LENS_INFO_AVAILABLE_FOCAL_LENGTHS: {
            break;
        }
        case CAMERA_LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION: {
            break;
        }
        case CAMERA_LENS_INFO_HYPERFOCAL_DISTANCE: {
            break;
        }
        case CAMERA_LENS_INFO_MINIMUM_FOCUS_DISTANCE: {
            break;
        }
        case CAMERA_LENS_INFO_SHADING_MAP_SIZE: {
            break;
        }
        case CAMERA_LENS_INFO_FOCUS_DISTANCE_CALIBRATION: {
            switch (value) {
                case CAMERA_LENS_INFO_FOCUS_DISTANCE_CALIBRATION_UNCALIBRATED:
                    msg = "UNCALIBRATED";
                    ret = 0;
                    break;
                case CAMERA_LENS_INFO_FOCUS_DISTANCE_CALIBRATION_APPROXIMATE:
                    msg = "APPROXIMATE";
                    ret = 0;
                    break;
                case CAMERA_LENS_INFO_FOCUS_DISTANCE_CALIBRATION_CALIBRATED:
                    msg = "CALIBRATED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_NOISE_REDUCTION_MODE: {
            switch (value) {
                case CAMERA_NOISE_REDUCTION_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_NOISE_REDUCTION_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case CAMERA_NOISE_REDUCTION_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                case CAMERA_NOISE_REDUCTION_MODE_MINIMAL:
                    msg = "MINIMAL";
                    ret = 0;
                    break;
                case CAMERA_NOISE_REDUCTION_MODE_ZERO_SHUTTER_LAG:
                    msg = "ZERO_SHUTTER_LAG";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_NOISE_REDUCTION_STRENGTH: {
            break;
        }
        case CAMERA_NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES: {
            break;
        }

        case CAMERA_REQUEST_ID: {
            break;
        }
        case CAMERA_REQUEST_METADATA_MODE: {
            switch (value) {
                case CAMERA_REQUEST_METADATA_MODE_NONE:
                    msg = "NONE";
                    ret = 0;
                    break;
                case CAMERA_REQUEST_METADATA_MODE_FULL:
                    msg = "FULL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_REQUEST_MAX_NUM_OUTPUT_STREAMS: {
            break;
        }
        case CAMERA_REQUEST_MAX_NUM_INPUT_STREAMS: {
            break;
        }
        case CAMERA_REQUEST_PIPELINE_DEPTH: {
            break;
        }
        case CAMERA_REQUEST_PIPELINE_MAX_DEPTH: {
            break;
        }
        case CAMERA_REQUEST_PARTIAL_RESULT_COUNT: {
            break;
        }
        case CAMERA_REQUEST_AVAILABLE_CAPABILITIES: {
            switch (value) {
                case CAMERA_REQUEST_AVAILABLE_CAPABILITIES_BACKWARD_COMPATIBLE:
                    msg = "BACKWARD_COMPATIBLE";
                    ret = 0;
                    break;
                case CAMERA_REQUEST_AVAILABLE_CAPABILITIES_MANUAL_SENSOR:
                    msg = "MANUAL_SENSOR";
                    ret = 0;
                    break;
                case CAMERA_REQUEST_AVAILABLE_CAPABILITIES_MANUAL_POST_PROCESSING:
                    msg = "MANUAL_POST_PROCESSING";
                    ret = 0;
                    break;
                case CAMERA_REQUEST_AVAILABLE_CAPABILITIES_RAW:
                    msg = "RAW";
                    ret = 0;
                    break;
                case CAMERA_REQUEST_AVAILABLE_CAPABILITIES_ZSL:
                    msg = "ZSL";
                    ret = 0;
                    break;
                case CAMERA_REQUEST_AVAILABLE_CAPABILITIES_READ_SENSOR_SETTINGS:
                    msg = "READ_SENSOR_SETTINGS";
                    ret = 0;
                    break;
                case CAMERA_REQUEST_AVAILABLE_CAPABILITIES_BURST_CAPTURE:
                    msg = "BURST_CAPTURE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_REQUEST_AVAILABLE_REQUEST_KEYS: {
            break;
        }
        case CAMERA_REQUEST_AVAILABLE_RESULT_KEYS: {
            break;
        }
        case CAMERA_REQUEST_AVAILABLE_CHARACTERISTICS_KEYS: {
            break;
        }

        case CAMERA_SCALER_CROP_REGION: {
            break;
        }
        case CAMERA_SCALER_AVAILABLE_JPEG_SIZES: {
            break;
        }
        case CAMERA_SCALER_AVAILABLE_MAX_DIGITAL_ZOOM: {
            break;
        }
        case CAMERA_SCALER_AVAILABLE_INPUT_OUTPUT_FORMATS_MAP: {
            break;
        }
        case CAMERA_SCALER_AVAILABLE_STREAM_CONFIGURATIONS: {
            break;
        }
        case CAMERA_SCALER_AVAILABLE_MIN_FRAME_DURATIONS: {
            break;
        }
        case CAMERA_SCALER_AVAILABLE_STALL_DURATIONS: {
            break;
        }
        case CAMERA_SCALER_CROPPING_TYPE: {
            switch (value) {
                case CAMERA_SCALER_CROPPING_TYPE_CENTER_ONLY:
                    msg = "CENTER_ONLY";
                    ret = 0;
                    break;
                case CAMERA_SCALER_CROPPING_TYPE_FREEFORM:
                    msg = "FREEFORM";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_SENSOR_EXPOSURE_TIME: {
            break;
        }
        case CAMERA_SENSOR_FRAME_DURATION: {
            break;
        }
        case CAMERA_SENSOR_SENSITIVITY: {
            break;
        }
        case CAMERA_SENSOR_REFERENCE_ILLUMINANT1: {
            switch (value) {
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_DAYLIGHT:
                    msg = "DAYLIGHT";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_FLUORESCENT:
                    msg = "FLUORESCENT";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_TUNGSTEN:
                    msg = "TUNGSTEN";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_FLASH:
                    msg = "FLASH";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_FINE_WEATHER:
                    msg = "FINE_WEATHER";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_CLOUDY_WEATHER:
                    msg = "CLOUDY_WEATHER";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_SHADE:
                    msg = "SHADE";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_DAYLIGHT_FLUORESCENT:
                    msg = "DAYLIGHT_FLUORESCENT";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_DAY_WHITE_FLUORESCENT:
                    msg = "DAY_WHITE_FLUORESCENT";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_COOL_WHITE_FLUORESCENT:
                    msg = "COOL_WHITE_FLUORESCENT";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_WHITE_FLUORESCENT:
                    msg = "WHITE_FLUORESCENT";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_STANDARD_A:
                    msg = "STANDARD_A";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_STANDARD_B:
                    msg = "STANDARD_B";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_STANDARD_C:
                    msg = "STANDARD_C";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_D55:
                    msg = "D55";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_D65:
                    msg = "D65";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_D75:
                    msg = "D75";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_D50:
                    msg = "D50";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_REFERENCE_ILLUMINANT1_ISO_STUDIO_TUNGSTEN:
                    msg = "ISO_STUDIO_TUNGSTEN";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_SENSOR_REFERENCE_ILLUMINANT2: {
            break;
        }
        case CAMERA_SENSOR_CALIBRATION_TRANSFORM1: {
            break;
        }
        case CAMERA_SENSOR_CALIBRATION_TRANSFORM2: {
            break;
        }
        case CAMERA_SENSOR_COLOR_TRANSFORM1: {
            break;
        }
        case CAMERA_SENSOR_COLOR_TRANSFORM2: {
            break;
        }
        case CAMERA_SENSOR_FORWARD_MATRIX1: {
            break;
        }
        case CAMERA_SENSOR_FORWARD_MATRIX2: {
            break;
        }
        case CAMERA_SENSOR_BASE_GAIN_FACTOR: {
            break;
        }
        case CAMERA_SENSOR_BLACK_LEVEL_PATTERN: {
            break;
        }
        case CAMERA_SENSOR_MAX_ANALOG_SENSITIVITY: {
            break;
        }
        case CAMERA_SENSOR_ORIENTATION: {
            break;
        }
        case CAMERA_SENSOR_PROFILE_HUE_SAT_MAP_DIMENSIONS: {
            break;
        }
        case CAMERA_SENSOR_TIMESTAMP: {
            break;
        }
        case CAMERA_SENSOR_TEMPERATURE: {
            break;
        }
        case CAMERA_SENSOR_NEUTRAL_COLOR_POINT: {
            break;
        }
        case CAMERA_SENSOR_NOISE_PROFILE: {
            break;
        }
        case CAMERA_SENSOR_PROFILE_HUE_SAT_MAP: {
            break;
        }
        case CAMERA_SENSOR_PROFILE_TONE_CURVE: {
            break;
        }
        case CAMERA_SENSOR_GREEN_SPLIT: {
            break;
        }
        case CAMERA_SENSOR_TEST_PATTERN_DATA: {
            break;
        }
        case CAMERA_SENSOR_TEST_PATTERN_MODE: {
            switch (value) {
                case CAMERA_SENSOR_TEST_PATTERN_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_TEST_PATTERN_MODE_SOLID_COLOR:
                    msg = "SOLID_COLOR";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_TEST_PATTERN_MODE_COLOR_BARS:
                    msg = "COLOR_BARS";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_TEST_PATTERN_MODE_COLOR_BARS_FADE_TO_GRAY:
                    msg = "COLOR_BARS_FADE_TO_GRAY";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_TEST_PATTERN_MODE_PN9:
                    msg = "PN9";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_TEST_PATTERN_MODE_CUSTOM1:
                    msg = "CUSTOM1";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_SENSOR_AVAILABLE_TEST_PATTERN_MODES: {
            break;
        }
        case CAMERA_SENSOR_OPAQUE_RAW_SIZE: {
            break;
        }
        case CAMERA_SENSOR_ROLLING_SHUTTER_SKEW: {
            break;
        }

        case CAMERA_SENSOR_INFO_ACTIVE_ARRAY_SIZE: {
            break;
        }
        case CAMERA_SENSOR_INFO_SENSITIVITY_RANGE: {
            break;
        }
        case CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT: {
            switch (value) {
                case CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGGB:
                    msg = "RGGB";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GRBG:
                    msg = "GRBG";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GBRG:
                    msg = "GBRG";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_BGGR:
                    msg = "BGGR";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGB:
                    msg = "RGB";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_SENSOR_INFO_EXPOSURE_TIME_RANGE: {
            break;
        }
        case CAMERA_SENSOR_INFO_MAX_FRAME_DURATION: {
            break;
        }
        case CAMERA_SENSOR_INFO_PHYSICAL_SIZE: {
            break;
        }
        case CAMERA_SENSOR_INFO_PIXEL_ARRAY_SIZE: {
            break;
        }
        case CAMERA_SENSOR_INFO_WHITE_LEVEL: {
            break;
        }
        case CAMERA_SENSOR_INFO_TIMESTAMP_SOURCE: {
            switch (value) {
                case CAMERA_SENSOR_INFO_TIMESTAMP_SOURCE_UNKNOWN:
                    msg = "UNKNOWN";
                    ret = 0;
                    break;
                case CAMERA_SENSOR_INFO_TIMESTAMP_SOURCE_REALTIME:
                    msg = "REALTIME";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_SHADING_MODE: {
            switch (value) {
                case CAMERA_SHADING_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_SHADING_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case CAMERA_SHADING_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_SHADING_STRENGTH: {
            break;
        }
        case CAMERA_SHADING_AVAILABLE_MODES: {
            break;
        }

        case CAMERA_STATISTICS_FACE_DETECT_MODE: {
            switch (value) {
                case CAMERA_STATISTICS_FACE_DETECT_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_STATISTICS_FACE_DETECT_MODE_SIMPLE:
                    msg = "SIMPLE";
                    ret = 0;
                    break;
                case CAMERA_STATISTICS_FACE_DETECT_MODE_FULL:
                    msg = "FULL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_STATISTICS_HISTOGRAM_MODE: {
            switch (value) {
                case CAMERA_STATISTICS_HISTOGRAM_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_STATISTICS_HISTOGRAM_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_STATISTICS_SHARPNESS_MAP_MODE: {
            switch (value) {
                case CAMERA_STATISTICS_SHARPNESS_MAP_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_STATISTICS_SHARPNESS_MAP_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_STATISTICS_HOT_PIXEL_MAP_MODE: {
            switch (value) {
                case CAMERA_STATISTICS_HOT_PIXEL_MAP_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_STATISTICS_HOT_PIXEL_MAP_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_STATISTICS_FACE_IDS: {
            break;
        }
        case CAMERA_STATISTICS_FACE_LANDMARKS: {
            break;
        }
        case CAMERA_STATISTICS_FACE_RECTANGLES: {
            break;
        }
        case CAMERA_STATISTICS_FACE_SCORES: {
            break;
        }
        case CAMERA_STATISTICS_HISTOGRAM: {
            break;
        }
        case CAMERA_STATISTICS_SHARPNESS_MAP: {
            break;
        }
        case CAMERA_STATISTICS_LENS_SHADING_CORRECTION_MAP: {
            break;
        }
        case CAMERA_STATISTICS_LENS_SHADING_MAP: {
            break;
        }
        case CAMERA_STATISTICS_PREDICTED_COLOR_GAINS: {
            break;
        }
        case CAMERA_STATISTICS_PREDICTED_COLOR_TRANSFORM: {
            break;
        }
        case CAMERA_STATISTICS_SCENE_FLICKER: {
            switch (value) {
                case CAMERA_STATISTICS_SCENE_FLICKER_NONE:
                    msg = "NONE";
                    ret = 0;
                    break;
                case CAMERA_STATISTICS_SCENE_FLICKER_50HZ:
                    msg = "50HZ";
                    ret = 0;
                    break;
                case CAMERA_STATISTICS_SCENE_FLICKER_60HZ:
                    msg = "60HZ";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_STATISTICS_HOT_PIXEL_MAP: {
            break;
        }
        case CAMERA_STATISTICS_LENS_SHADING_MAP_MODE: {
            switch (value) {
                case CAMERA_STATISTICS_LENS_SHADING_MAP_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_STATISTICS_LENS_SHADING_MAP_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES: {
            break;
        }
        case CAMERA_STATISTICS_INFO_HISTOGRAM_BUCKET_COUNT: {
            break;
        }
        case CAMERA_STATISTICS_INFO_MAX_FACE_COUNT: {
            break;
        }
        case CAMERA_STATISTICS_INFO_MAX_HISTOGRAM_COUNT: {
            break;
        }
        case CAMERA_STATISTICS_INFO_MAX_SHARPNESS_MAP_VALUE: {
            break;
        }
        case CAMERA_STATISTICS_INFO_SHARPNESS_MAP_SIZE: {
            break;
        }
        case CAMERA_STATISTICS_INFO_AVAILABLE_HOT_PIXEL_MAP_MODES: {
            break;
        }

        case CAMERA_TONEMAP_CURVE_BLUE: {
            break;
        }
        case CAMERA_TONEMAP_CURVE_GREEN: {
            break;
        }
        case CAMERA_TONEMAP_CURVE_RED: {
            break;
        }
        case CAMERA_TONEMAP_MODE: {
            switch (value) {
                case CAMERA_TONEMAP_MODE_CONTRAST_CURVE:
                    msg = "CONTRAST_CURVE";
                    ret = 0;
                    break;
                case CAMERA_TONEMAP_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case CAMERA_TONEMAP_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                case CAMERA_TONEMAP_MODE_GAMMA_VALUE:
                    msg = "GAMMA_VALUE";
                    ret = 0;
                    break;
                case CAMERA_TONEMAP_MODE_PRESET_CURVE:
                    msg = "PRESET_CURVE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_TONEMAP_MAX_CURVE_POINTS: {
            break;
        }
        case CAMERA_TONEMAP_AVAILABLE_TONE_MAP_MODES: {
            break;
        }
        case CAMERA_TONEMAP_GAMMA: {
            break;
        }
        case CAMERA_TONEMAP_PRESET_CURVE: {
            switch (value) {
                case CAMERA_TONEMAP_PRESET_CURVE_SRGB:
                    msg = "SRGB";
                    ret = 0;
                    break;
                case CAMERA_TONEMAP_PRESET_CURVE_REC709:
                    msg = "REC709";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_LED_TRANSMIT: {
            switch (value) {
                case CAMERA_LED_TRANSMIT_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_LED_TRANSMIT_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_LED_AVAILABLE_LEDS: {
            switch (value) {
                case CAMERA_LED_AVAILABLE_LEDS_TRANSMIT:
                    msg = "TRANSMIT";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_INFO_SUPPORTED_HARDWARE_LEVEL: {
            switch (value) {
                case CAMERA_INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED:
                    msg = "LIMITED";
                    ret = 0;
                    break;
                case CAMERA_INFO_SUPPORTED_HARDWARE_LEVEL_FULL:
                    msg = "FULL";
                    ret = 0;
                    break;
                case CAMERA_INFO_SUPPORTED_HARDWARE_LEVEL_LEGACY:
                    msg = "LEGACY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_BLACK_LEVEL_LOCK: {
            switch (value) {
                case CAMERA_BLACK_LEVEL_LOCK_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case CAMERA_BLACK_LEVEL_LOCK_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_SYNC_FRAME_NUMBER: {
            switch (value) {
                case CAMERA_SYNC_FRAME_NUMBER_CONVERGING:
                    msg = "CONVERGING";
                    ret = 0;
                    break;
                case CAMERA_SYNC_FRAME_NUMBER_UNKNOWN:
                    msg = "UNKNOWN";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case CAMERA_SYNC_MAX_LATENCY: {
            switch (value) {
                case CAMERA_SYNC_MAX_LATENCY_PER_FRAME_CONTROL:
                    msg = "PER_FRAME_CONTROL";
                    ret = 0;
                    break;
                case CAMERA_SYNC_MAX_LATENCY_UNKNOWN:
                    msg = "UNKNOWN";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case CAMERA_REPROCESS_MAX_CAPTURE_STALL: {
            break;
        }

        case INTEL_INFO_AVAILABLE_CONFIGURATIONS: {
            break;
        }
        case INTEL_INFO_AVAILABLE_FEATURES: {
            switch (value) {
                case INTEL_INFO_AVAILABLE_FEATURES_MANUAL_EXPOSURE:
                    msg = "MANUAL_EXPOSURE";
                    ret = 0;
                    break;
                case INTEL_INFO_AVAILABLE_FEATURES_MANUAL_WHITE_BALANCE:
                    msg = "MANUAL_WHITE_BALANCE";
                    ret = 0;
                    break;
                case INTEL_INFO_AVAILABLE_FEATURES_IMAGE_ENHANCEMENT:
                    msg = "IMAGE_ENHANCEMENT";
                    ret = 0;
                    break;
                case INTEL_INFO_AVAILABLE_FEATURES_NOISE_REDUCTION:
                    msg = "NOISE_REDUCTION";
                    ret = 0;
                    break;
                case INTEL_INFO_AVAILABLE_FEATURES_SCENE_MODE:
                    msg = "SCENE_MODE";
                    ret = 0;
                    break;
                case INTEL_INFO_AVAILABLE_FEATURES_WEIGHT_GRID_MODE:
                    msg = "WEIGHT_GRID_MODE";
                    ret = 0;
                    break;
                case INTEL_INFO_AVAILABLE_FEATURES_PER_FRAME_CONTROL:
                    msg = "PER_FRAME_CONTROL";
                    ret = 0;
                    break;
                case INTEL_INFO_AVAILABLE_FEATURES_ISP_CONTROL:
                    msg = "ISP_CONTROL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_INFO_AE_EXPOSURE_TIME_RANGE: {
            break;
        }
        case INTEL_INFO_AE_GAIN_RANGE: {
            break;
        }
        case INTEL_INFO_WFOV: {
            switch (value) {
                case INTEL_INFO_WFOV_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_INFO_WFOV_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_INFO_SENSOR_MOUNT_TYPE: {
            switch (value) {
                case INTEL_INFO_SENSOR_MOUNT_TYPE_WALL_MOUNTED:
                    msg = "WALL_MOUNTED";
                    ret = 0;
                    break;
                case INTEL_INFO_SENSOR_MOUNT_TYPE_CEILING_MOUNTER:
                    msg = "CEILING_MOUNTER";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case INTEL_CONTROL_IMAGE_ENHANCEMENT: {
            break;
        }
        case INTEL_CONTROL_SENSITIVITY_GAIN: {
            break;
        }
        case INTEL_CONTROL_FRAME_RATE: {
            break;
        }
        case INTEL_CONTROL_AE_CONVERGE_SPEED: {
            switch (value) {
                case INTEL_CONTROL_AE_CONVERGE_SPEED_NORMAL:
                    msg = "NORMAL";
                    ret = 0;
                    break;
                case INTEL_CONTROL_AE_CONVERGE_SPEED_MID:
                    msg = "MID";
                    ret = 0;
                    break;
                case INTEL_CONTROL_AE_CONVERGE_SPEED_LOW:
                    msg = "LOW";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_NR_MODE: {
            switch (value) {
                case INTEL_CONTROL_NR_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_CONTROL_NR_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case INTEL_CONTROL_NR_MODE_MANUAL_NORMAL:
                    msg = "MANUAL_NORMAL";
                    ret = 0;
                    break;
                case INTEL_CONTROL_NR_MODE_MANUAL_EXPERT:
                    msg = "MANUAL_EXPERT";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_NR_LEVEL: {
            break;
        }
        case INTEL_CONTROL_IRIS_MODE: {
            switch (value) {
                case INTEL_CONTROL_IRIS_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case INTEL_CONTROL_IRIS_MODE_MANUAL:
                    msg = "MANUAL";
                    ret = 0;
                    break;
                case INTEL_CONTROL_IRIS_MODE_CUSTOMIZED:
                    msg = "CUSTOMIZED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY: {
            switch (value) {
                case INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY_SHUTTER:
                    msg = "SHUTTER";
                    ret = 0;
                    break;
                case INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY_ISO:
                    msg = "ISO";
                    ret = 0;
                    break;
                case INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY_APERTURE:
                    msg = "APERTURE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_IRIS_LEVEL: {
            break;
        }
        case INTEL_CONTROL_WDR_MODE: {
            switch (value) {
                case INTEL_CONTROL_WDR_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_CONTROL_WDR_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                case INTEL_CONTROL_WDR_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_WDR_LEVEL: {
            break;
        }
        case INTEL_CONTROL_BLC_AREA_MODE: {
            switch (value) {
                case INTEL_CONTROL_BLC_AREA_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_CONTROL_BLC_AREA_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_SCENE_MODE: {
            switch (value) {
                case INTEL_CONTROL_SCENE_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case INTEL_CONTROL_SCENE_MODE_HDR:
                    msg = "HDR";
                    ret = 0;
                    break;
                case INTEL_CONTROL_SCENE_MODE_ULL:
                    msg = "ULL";
                    ret = 0;
                    break;
                case INTEL_CONTROL_SCENE_MODE_VIDEO_LL:
                    msg = "VIDEO_LL";
                    ret = 0;
                    break;
                case INTEL_CONTROL_SCENE_MODE_HDR2:
                    msg = "HDR2";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_WEIGHT_GRID_MODE: {
            switch (value) {
                case INTEL_CONTROL_WEIGHT_GRID_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case INTEL_CONTROL_WEIGHT_GRID_MODE_CUSTOM_WEIGHT_GRID1:
                    msg = "CUSTOM_WEIGHT_GRID1";
                    ret = 0;
                    break;
                case INTEL_CONTROL_WEIGHT_GRID_MODE_CUSTOM_WEIGHT_GRID2:
                    msg = "CUSTOM_WEIGHT_GRID2";
                    ret = 0;
                    break;
                case INTEL_CONTROL_WEIGHT_GRID_MODE_CUSTOM_WEIGHT_GRID3:
                    msg = "CUSTOM_WEIGHT_GRID3";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_AE_CONVERGE_SPEED_MODE: {
            switch (value) {
                case INTEL_CONTROL_AE_CONVERGE_SPEED_MODE_HAL:
                    msg = "HAL";
                    ret = 0;
                    break;
                case INTEL_CONTROL_AE_CONVERGE_SPEED_MODE_AIQ:
                    msg = "AIQ";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_DEINTERLACE_MODE: {
            switch (value) {
                case INTEL_CONTROL_DEINTERLACE_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_CONTROL_DEINTERLACE_MODE_WEAVING:
                    msg = "WEAVING";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_MAKERNOTE_DATA: {
            break;
        }
        case INTEL_CONTROL_CUSTOM_AIC_PARAM: {
            break;
        }
        case INTEL_CONTROL_MAKERNOTE_MODE: {
            switch (value) {
                case INTEL_CONTROL_MAKERNOTE_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_CONTROL_MAKERNOTE_MODE_JPEG:
                    msg = "JPEG";
                    ret = 0;
                    break;
                case INTEL_CONTROL_MAKERNOTE_MODE_RAW:
                    msg = "RAW";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_YUV_COLOR_RANGE: {
            switch (value) {
                case INTEL_CONTROL_YUV_COLOR_RANGE_FULL:
                    msg = "FULL";
                    ret = 0;
                    break;
                case INTEL_CONTROL_YUV_COLOR_RANGE_REDUCED:
                    msg = "REDUCED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_SENSITIVITY_GAIN_RANGE: {
            break;
        }
        case INTEL_CONTROL_EXPOSURE_TIME_RANGE: {
            break;
        }
        case INTEL_CONTROL_FISHEYE_DEWARPING_MODE: {
            switch (value) {
                case INTEL_CONTROL_FISHEYE_DEWARPING_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_CONTROL_FISHEYE_DEWARPING_MODE_REARVIEW:
                    msg = "REARVIEW";
                    ret = 0;
                    break;
                case INTEL_CONTROL_FISHEYE_DEWARPING_MODE_HITCHVIEW:
                    msg = "HITCHVIEW";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_LTM_TUNING_DATA: {
            break;
        }
        case INTEL_CONTROL_DIGITAL_ZOOM_RATIO: {
            break;
        }
        case INTEL_CONTROL_LDC_MODE: {
            switch (value) {
                case INTEL_CONTROL_LDC_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_CONTROL_LDC_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_RSC_MODE: {
            switch (value) {
                case INTEL_CONTROL_RSC_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_CONTROL_RSC_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_FLIP_MODE: {
            switch (value) {
                case INTEL_CONTROL_FLIP_MODE_NONE:
                    msg = "NONE";
                    ret = 0;
                    break;
                case INTEL_CONTROL_FLIP_MODE_VFLIP:
                    msg = "VFLIP";
                    ret = 0;
                    break;
                case INTEL_CONTROL_FLIP_MODE_HFLIP:
                    msg = "HFLIP";
                    ret = 0;
                    break;
                case INTEL_CONTROL_FLIP_MODE_VHFLIP:
                    msg = "VHFLIP";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_MONO_DOWNSCALE: {
            switch (value) {
                case INTEL_CONTROL_MONO_DOWNSCALE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case INTEL_CONTROL_MONO_DOWNSCALE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case INTEL_CONTROL_RUN3_A_CADENCE: {
            break;
        }
        case INTEL_CONTROL_VIEW_PROJECTION: {
            break;
        }
        case INTEL_CONTROL_VIEW_ROTATION: {
            break;
        }
        case INTEL_CONTROL_VIEW_FINE_ADJUSTMENTS: {
            break;
        }
        case INTEL_CONTROL_CAMERA_ROTATION: {
            break;
        }
        case INTEL_CONTROL_SCALER_CROP_REGION: {
            break;
        }

        case INTEL_CONTROL_ISP_SUPPORTED_CTRL_IDS: {
            break;
        }
        case INTEL_CONTROL_ISP_ENABLED_CTRL_IDS: {
            break;
        }
        case INTEL_CONTROL_ISP_WB_GAINS: {
            break;
        }
        case INTEL_CONTROL_ISP_COLOR_CORRECTION_MATRIX: {
            break;
        }
        case INTEL_CONTROL_ISP_ADVANCED_COLOR_CORRECTION_MATRIX: {
            break;
        }
        case INTEL_CONTROL_ISP_BXT_CSC: {
            break;
        }
        case INTEL_CONTROL_ISP_BXT_DEMOSAIC: {
            break;
        }
        case INTEL_CONTROL_ISP_SC_IEFD: {
            break;
        }
        case INTEL_CONTROL_ISP_SEE: {
            break;
        }
        case INTEL_CONTROL_ISP_BNLM: {
            break;
        }
        case INTEL_CONTROL_ISP_TNR5_21: {
            break;
        }
        case INTEL_CONTROL_ISP_XNR_DSS: {
            break;
        }
        case INTEL_CONTROL_ISP_GAMMA_TONE_MAP: {
            break;
        }
        case INTEL_CONTROL_ISP_TNR5_22: {
            break;
        }
        case INTEL_CONTROL_ISP_TNR5_25: {
            break;
        }

    }

    snprintf(dst, size, "%s", msg);
    dst[size - 1] = '\0';

    return ret;
}

#define ICAMERA_METADATA_ENUM_STRING_MAX_SIZE 24
