
 /************************************************************************
  * Copyright 2005-2009 by Freescale Semiconductor, Inc.
  * All modifications are confidential and proprietary information
  * of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
  ************************************************************************/

#ifndef G711_DEC_API_H
#define G711_DEC_API_H
/*==================================================================================================

     Header Name: g711_dec_api.h

     General Description:

====================================================================================================
                              Freescale Confidential Proprietary
                      (c) Copyright Freescale 2005, All Rights Reserved


Revision History:
                            Modification     Tracking
Author                          Date          Number     Description of Changes
-------------------------   ------------    ----------   -------------------------------------------
Priyank Saxena              Jun/17/2005                   Initial version
Neha Srivastava             Jan/24/2007                   Elinux Ported Version
Qiu Cunshou                 May/22/2008     engr77040    Add API for version
====================================================================================================
                                         INCLUDE FILES
==================================================================================================*/
typedef char G711_S8;
typedef unsigned char G711_U8;
typedef short G711_S16;
typedef unsigned short G711_U16;
typedef int G711_S32;
typedef unsigned int G711_U32;


/*==================================================================================================
                                           CONSTANTS
==================================================================================================*/

/*==================================================================================================
                                            MACROS
==================================================================================================*/

/*==================================================================================================
                                             ENUMS
==================================================================================================*/

/*==================================================================================================
                                 STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/

/*==================================================================================================
                                 GLOBAL VARIABLE DECLARATIONS
==================================================================================================*/

/*==================================================================================================
                                     FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __SYMBIAN32__
#define EXPORT_C __declspec(dllexport)
#else
#define EXPORT_C
#endif
#ifdef __cplusplus
extern "C"
{
#endif
 void g711AlawDecode(G711_U16 size, G711_U8 *inBuf, G711_S16 *outBuf);
 void g711MulawDecode(G711_U16 size, G711_U8 *inBuf, G711_S16 *outBuf);
 const char *G711D_get_version_info(void);
#ifdef __cplusplus
}
#endif
#endif /* G711_DEC_API_H */
