/*****************************************************************************
 * mpg_demuxer_api.h
 *
 * Copyright (c) 2008 Freescale Semiconductor Inc.
 * All rights reserved.
 *
 * Use of Freescale code is governed by terms and conditions
 * stated in the accompanying licensing statement.
 *
 * Description: 
 * MPEG demuxer API header file.
 * 
 * 
 * Revision History:
 * -----------------
 * Code Ver	    YYYY-MM-DD      Author		   Description
 * --------	    ----------        -------- 	   -------------
 * 0.1 		    2008-06-12        ZhaoBo           Create this file
 * 0.2                2008-07-22        ZhaoBo           Add support for AC3/LPCM/DTS/AAC audio
 * 0.2                2008-07-24        ZhaoBo           Add fast process(Scan) to set up index table            
****************************************************************************/

#ifndef MPG_DEMUXER_API_H
#define MPG_DEMUXER_API_H
 
#include "fsl_datatype.h" 

#define NO_PROGRAM_SUPPORT_MAX 32

#define NO_MEDIA_SUPPORT_MAX 4
#define UNREGISTERED_STREAM  (-1)

/*defines for flag in callback function :DemuxOutput  */
#define FSL_MPG_DEMUX_PTS_VALID     ((U32)(1<<0))
#define FSL_MPG_DEMUX_DTS_VALID     ((U32)(1<<1))
#define FSL_MPG_DEMUX_NEW_PES       ((U32)(1<<2))


typedef enum
{
    FSL_MPG_DEMUX_NOMEDIA=0,
	FSL_MPG_DEMUX_AUDIO_STREAM,
	FSL_MPG_DEMUX_VIDEO_STREAM,
	FSL_MPG_DEMUX_UNKNOWN_MEDIA
} FSL_MPG_DEMUX_MEDIA_TYPE_T;

typedef enum
{
    FSL_MPEG_A_CH_MODE_STEREO=0,
	FSL_MPEG_A_CH_MODE_JOINTSTEREO,
	FSL_MPEG_A_CH_MODE_DUALCHANNEL,
	FSL_MPEG_A_CH_MODE_SINGLECHANNEL,
	FSL_MPEG_A_CH_MODE_UNKNOWN
} FSL_MPG_DEMUX_CHANNEL_MODE_T;

typedef enum
{
    FSL_MPG_DEMUX_NOVIDEO = 0,
    FSL_MPG_DEMUX_MPEG2_VIDEO,
    FSL_MPG_DEMUX_UNKNOWN_VIDEO
} FSL_MPG_DEMUX_VIDEO_TYPE_T;



typedef enum
{
    FSL_MPG_DEMUX_NOAUDIO = 0,
	FSL_MPG_DEMUX_MP1_AUDIO,	
	FSL_MPG_DEMUX_MP2_AUDIO,
    FSL_MPG_DEMUX_MP3_AUDIO,
    FSL_MPG_DEMUX_AAC_AUDIO,
    FSL_MPG_DEMUX_AC3_AUDIO,
    FSL_MPG_DEMUX_DTS_AUDIO,
    FSL_MPG_DEMUX_PCM_AUDIO,
    FSL_MPG_DEMUX_UNKNOWN_AUDIO
} FSL_MPG_DEMUX_AUDIO_TYPE_T; 
 
typedef enum
{
    FSL_MPG_DEMUX_CMD_RESET=0,  
	FSL_MPG_DEMUX_CMD_RESYNC,
	FSL_MPG_DEMUX_CMD_SELECT_PROGRAM,
	FSL_MPG_DEMUX_CMD_ENABLE_STREAM,
	FSL_MPG_DEMUX_CMD_DISABLE_STREAM,
	FSL_MPG_DEMUX_CMD_SET_VBUFSIZE,
	FSL_MPG_DEMUX_CMD_SET_ABUFSIZE,
	FSL_MPG_DEMUX_CMD_SET_SKIPFLAG,
	FSL_MPG_DEMUX_CMD_GET_MAXPESSIZE_AUDIO,
	FSL_MPG_DEMUX_CMD_GET_MAXPESSIZE_VIDEO,
	FSL_MPG_DEMUX_CMD_GET_MPEGSH_PTR,
	FSL_MPG_DEMUX_CMD_GET_MPEGSH_SIZE,
	FSL_MPG_DEMUX_CMD_MAX
} FSL_MPG_DEMUX_CMD_T;

typedef enum
{
    FSL_MPG_DEMUX_RT_SUCCESS=0,
	FSL_MPG_DEMUX_RT_MOREDATA,
	FSL_MPG_DEMUX_RT_NVALID_STREAM,
	FSL_MPG_DEMUX_RT_EOS,
	FSL_MPG_DEMUX_RT_NVALIDCMD,
	FSL_MPG_DEMUX_RT_NULL_PARSER,
	FSL_MPG_DEMUX_RT_MALLOC_FAILED,
	FSL_MPG_DEMUX_RT_DISCONTINUITY_AUDIO,
	FSL_MPG_DEMUX_RT_DISCONTINUITY_VIDEO,
	FSL_MPG_DEMUX_RT_INPUTBUF_SMALL,
	FSL_MPG_DEMUX_RT_VITAL_FAULT
} FSL_MPG_DEMUX_RET_TYPE_T;


typedef struct FSL_MPG_DEMUX_BD_S
{
    FSL_VOID *     pPtr;      /* buffer pointer */
	FSL_VOID *     pCnxt;     /* versatile context */
    U32            uliLen;    /* length of the buffer, in bytes */
    U32            uliFill;   /* length of the valid data in the buffer, in bytes */
} FSL_MPG_DEMUX_BD_T;          /* a data buffer */


typedef struct FSL_MPG_DEMUX_BD_SET_S
{
	FSL_MPG_DEMUX_BD_T *  pPtr;         /* pointer to the buffer array */
	U16                   usiCntBDSet;  /* number of the buffers in the array */ 
} FSL_MPG_DEMUX_BD_SET_T;              /* data buffer set */


typedef struct FSL_VIDEO_PROPERTY_S
{
    FSL_MPG_DEMUX_VIDEO_TYPE_T    enuVideoType;
	U32                           uliVideoID;
    U32                           uliVideoWidth;
    U32                           uliVideoHeight;
    U32                           uliVideoBitRate;
    U32                           uliFRNumerator;
    U32                           uliFRDenominator;  
} FSL_VIDEO_PROPERTY_T; 

typedef struct FSL_AUDIO_PROPERTY_S
{
    FSL_MPG_DEMUX_AUDIO_TYPE_T    enuAudioType;
	U32                           uliAudioID;
    U32                           uliAudioSampleRate;
    U16                           usiAudioChannels;
	FSL_MPG_DEMUX_CHANNEL_MODE_T  enuAudioChannelMode;
    U32                           uliAudioBitRate;

} FSL_AUDIO_PROPERTY_T;

typedef struct FSL_MPEGSTREAM_S
{
    FSL_MPG_DEMUX_MEDIA_TYPE_T    enuStreamType;
	U32            uliPropertyValid;
	union
	{
        FSL_VIDEO_PROPERTY_T    VideoProperty;
		FSL_AUDIO_PROPERTY_T    AudioProperty;
	} MediaProperty;

} FSL_MPEGSTREAM_T;



typedef struct FSL_MPG_DEMUX_SYSINFO_S
{
    U32                           uliNoStreams;
	U32                           uliPSFlag;
	FSL_MPEGSTREAM_T              Stream[NO_MEDIA_SUPPORT_MAX];
    
}FSL_MPG_DEMUX_SYSINFO_T;


typedef struct FSL_MPG_DEMUX_PSI_S
{
    U8    IsTS;
	U8    Programs;
	U16   ProgramNumber[NO_PROGRAM_SUPPORT_MAX];
	   
} FSL_MPG_DEMUX_PSI_T;



typedef struct FSL_MPG_DEMUX_S
{
    FSL_MPG_DEMUX_PSI_T               TS_PSI;
	FSL_MPG_DEMUX_SYSINFO_T           SystemInfo;
	FSL_MPG_DEMUX_BD_SET_T            InputBuffer;
	FSL_VOID *                        pDemuxContext;
	FSL_VOID *                        pAppContext;

	
	/*call back functions  */
	FSL_VOID *                  (*DemuxMalloc) (FSL_VOID * pAppContext, U32 Size);
	FSL_VOID                    (*DemuxFree)   (FSL_VOID * pAppContext, FSL_VOID *Ptr );
	FSL_VOID *                  (*DemuxRequestBuffer)(FSL_VOID  * pAppContext,U32 StreamID,U32 Size,U32 NewPacket);  
    S32                         (*DemuxOutput) (FSL_VOID * pAppContext,U32 StreamID, FSL_VOID *pES, U32 Size,U64 PTS,U64 DTS,U32 Flag); 
	S32                         (*DemuxOutputIndex) (FSL_VOID * pAppContext,U32 StreamID, U32 BufIndex, S32 BufOffset,U64 PTS,U64 DTS,U32 Flag);
} FSL_MPG_DEMUX_T;


#ifdef __cplusplus
extern "C" {
#endif

FSL_MPG_DEMUX_RET_TYPE_T FSL_MPG_DEMUX_Open(FSL_MPG_DEMUX_T *pDemuxer);

FSL_MPG_DEMUX_RET_TYPE_T FSL_MPG_DEMUX_GetPSI(FSL_MPG_DEMUX_T *pDemuxer);

FSL_MPG_DEMUX_RET_TYPE_T FSL_MPG_DEMUX_Probe(FSL_MPG_DEMUX_T *pDemuxer);

FSL_MPG_DEMUX_RET_TYPE_T FSL_MPG_DEMUX_Control(FSL_MPG_DEMUX_T *pDemuxer, FSL_MPG_DEMUX_CMD_T Cmd, FSL_VOID *Args);

FSL_MPG_DEMUX_RET_TYPE_T FSL_MPG_DEMUX_Process(FSL_MPG_DEMUX_T *pDemuxer);

FSL_MPG_DEMUX_RET_TYPE_T FSL_MPG_DEMUX_Scan(FSL_MPG_DEMUX_T *pDemuxer);

const U8 *               FSL_MPG_DEMUX_Version_Info(FSL_VOID);

FSL_MPG_DEMUX_RET_TYPE_T FSL_MPG_DEMUX_Close(FSL_MPG_DEMUX_T *pDemuxer);

#ifdef __cplusplus
}
#endif

#endif /*MPG_DEMUXER_API_H   */
