/*
 * Decompiled with CFR 0.152.
 */
package old_logformat.slog2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import old_base.drawable.Category;
import old_base.drawable.Drawable;
import old_base.drawable.Primitive;
import old_base.drawable.Shadow;
import old_base.drawable.TimeBoundingBox;
import old_base.drawable.Topology;
import old_base.io.MixedDataInput;
import old_base.io.MixedDataOutput;
import old_logformat.slog2.BufForObjects;
import old_logformat.slog2.IteratorOfAllDrawables;
import old_logformat.slog2.IteratorOfBackDrawables;
import old_logformat.slog2.IteratorOfForeDrawables;
import old_logformat.slog2.LineIDMap;

public class BufForShadows
extends BufForObjects {
    private static final int INIT_BYTESIZE = 42;
    private Map buf4shadows;
    private Map shadowdefs_map;
    private List buf4nestable;
    private List buf4nestless;
    private Drawable.Order buf4dobj_order;
    private boolean isOutputBuf;
    private boolean haveObjectsBeenSaved;
    private int total_bytesize;

    public BufForShadows(boolean bl) {
        this.isOutputBuf = bl;
        if (this.isOutputBuf) {
            this.buf4shadows = new HashMap();
            this.buf4nestable = new ArrayList();
            this.buf4nestless = new ArrayList();
            this.buf4dobj_order = Drawable.INCRE_FINALTIME_ORDER;
        } else {
            this.buf4shadows = null;
            this.buf4nestable = null;
            this.buf4nestless = null;
            this.buf4dobj_order = Drawable.INCRE_STARTTIME_ORDER;
        }
        this.shadowdefs_map = null;
        this.haveObjectsBeenSaved = false;
        this.total_bytesize = 42;
    }

    public void setMapOfTopologyToShadowDef(Map map) {
        this.shadowdefs_map = map;
    }

    public int getByteSize() {
        return this.total_bytesize;
    }

    public void add(Primitive primitive) {
        ArrayList<Topology> arrayList = new ArrayList<Topology>();
        Topology topology = primitive.getCategory().getTopology();
        arrayList.add(topology);
        arrayList.addAll(primitive.getListOfVertexLineIDs());
        Shadow shadow = (Shadow)this.buf4shadows.get(arrayList);
        if (shadow == null) {
            Category category = (Category)this.shadowdefs_map.get(topology);
            category.setUsed(true);
            shadow = new Shadow(category, primitive);
            this.buf4shadows.put(arrayList, shadow);
            this.total_bytesize += shadow.getByteSize();
        } else {
            this.total_bytesize -= shadow.getByteSize();
            shadow.mergeWithPrimitive(primitive);
            this.total_bytesize += shadow.getByteSize();
        }
    }

    public void empty() {
        if (this.haveObjectsBeenSaved) {
            this.buf4nestable.clear();
            this.buf4nestless.clear();
            this.buf4dobj_order = Drawable.INCRE_FINALTIME_ORDER;
            this.buf4shadows.clear();
            this.haveObjectsBeenSaved = false;
            this.total_bytesize = 42;
        }
    }

    public void mergeWith(BufForShadows bufForShadows) {
        Iterator iterator = bufForShadows.buf4shadows.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List list = (List)entry.getKey();
            Shadow shadow = (Shadow)this.buf4shadows.get(list);
            if (shadow == null) {
                shadow = new Shadow((Shadow)entry.getValue());
                this.buf4shadows.put(list, shadow);
                this.total_bytesize += shadow.getByteSize();
                continue;
            }
            this.total_bytesize -= shadow.getByteSize();
            shadow.mergeWithShadow((Shadow)entry.getValue());
            this.total_bytesize += shadow.getByteSize();
        }
    }

    public void initializeMapOfCategoryWeights() {
        Iterator iterator = this.buf4shadows.values().iterator();
        while (iterator.hasNext()) {
            ((Shadow)iterator.next()).initializeMapOfCategoryWeights();
        }
    }

    public void finalizeMapOfCategoryWeights() {
        Iterator iterator = this.buf4shadows.values().iterator();
        while (iterator.hasNext()) {
            ((Shadow)iterator.next()).finalizeMapOfCategoryWeights();
        }
    }

    public int getNumOfPrimitives() {
        if (this.isOutputBuf) {
            return this.buf4shadows.size();
        }
        return this.buf4nestable.size() + this.buf4nestless.size();
    }

    public int getNumOfDrawables() {
        return this.getNumOfPrimitives();
    }

    private long getNumOfRealObjects() {
        long l = 0L;
        if (this.isOutputBuf) {
            Iterator iterator = this.buf4shadows.values().iterator();
            while (iterator.hasNext()) {
                l += ((Shadow)iterator.next()).getNumOfRealObjects();
            }
        } else {
            Iterator iterator = this.buf4nestable.iterator();
            while (iterator.hasNext()) {
                l += ((Shadow)iterator.next()).getNumOfRealObjects();
            }
            iterator = this.buf4nestless.iterator();
            while (iterator.hasNext()) {
                l += ((Shadow)iterator.next()).getNumOfRealObjects();
            }
        }
        return l;
    }

    public Iterator nestableForeIterator(TimeBoundingBox timeBoundingBox, boolean bl) {
        return new IteratorOfForeDrawables(this.buf4nestable, timeBoundingBox);
    }

    public Iterator nestlessForeIterator(TimeBoundingBox timeBoundingBox) {
        return new IteratorOfForeDrawables(this.buf4nestless, timeBoundingBox);
    }

    public Iterator nestableBackIterator(TimeBoundingBox timeBoundingBox, boolean bl) {
        return new IteratorOfBackDrawables(this.buf4nestable, timeBoundingBox);
    }

    public Iterator nestlessBackIterator(TimeBoundingBox timeBoundingBox) {
        return new IteratorOfBackDrawables(this.buf4nestless, timeBoundingBox);
    }

    public LineIDMap getIdentityLineIDMap() {
        return BufForObjects.toIdentityLineIDMap(this.buf4shadows.values());
    }

    public void reorderDrawables(Drawable.Order order) {
        if (!this.buf4dobj_order.equals(order)) {
            this.buf4dobj_order = order;
            Collections.sort(this.buf4nestable, this.buf4dobj_order);
            Collections.sort(this.buf4nestless, this.buf4dobj_order);
        }
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        super.writeObject(mixedDataOutput);
        Iterator iterator = this.buf4shadows.values().iterator();
        while (iterator.hasNext()) {
            Shadow shadow = (Shadow)iterator.next();
            if (shadow.getCategory().getTopology().isState()) {
                this.buf4nestable.add(shadow);
                continue;
            }
            this.buf4nestless.add(shadow);
        }
        this.reorderDrawables(Drawable.INCRE_STARTTIME_ORDER);
        int n = this.buf4nestless.size();
        mixedDataOutput.writeInt(n);
        Iterator iterator2 = this.buf4nestless.iterator();
        while (iterator2.hasNext()) {
            ((Shadow)iterator2.next()).writeObject(mixedDataOutput);
        }
        n = this.buf4nestable.size();
        mixedDataOutput.writeInt(n);
        iterator2 = this.buf4nestable.iterator();
        while (iterator2.hasNext()) {
            ((Shadow)iterator2.next()).writeObject(mixedDataOutput);
        }
        this.haveObjectsBeenSaved = true;
    }

    public BufForShadows(MixedDataInput mixedDataInput, Map map) throws IOException {
        this(false);
        this.readObject(mixedDataInput, map);
    }

    public void readObject(MixedDataInput mixedDataInput, Map map) throws IOException {
        Shadow shadow;
        int n;
        super.readObject(mixedDataInput);
        int n2 = mixedDataInput.readInt();
        this.buf4nestless = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            shadow = new Shadow(mixedDataInput);
            shadow.resolveCategory(map);
            this.buf4nestless.add(shadow);
            this.total_bytesize += shadow.getByteSize();
        }
        n2 = mixedDataInput.readInt();
        this.buf4nestable = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            shadow = new Shadow(mixedDataInput);
            shadow.resolveCategory(map);
            this.buf4nestable.add(shadow);
            this.total_bytesize += shadow.getByteSize();
        }
    }

    public String toString() {
        IteratorOfAllDrawables iteratorOfAllDrawables;
        StringBuffer stringBuffer = new StringBuffer("    BufForShadows{ ");
        stringBuffer.append(super.toString());
        stringBuffer.append(" Nrobjs=" + this.getNumOfRealObjects());
        stringBuffer.append(" }\n");
        if (this.isOutputBuf) {
            iteratorOfAllDrawables = this.buf4shadows.values().iterator();
        } else {
            IteratorOfForeDrawables iteratorOfForeDrawables = new IteratorOfForeDrawables(this.buf4nestable, this);
            IteratorOfForeDrawables iteratorOfForeDrawables2 = new IteratorOfForeDrawables(this.buf4nestless, this);
            iteratorOfAllDrawables = new IteratorOfAllDrawables(iteratorOfForeDrawables, iteratorOfForeDrawables2, this.buf4dobj_order);
        }
        int n = 1;
        while (iteratorOfAllDrawables.hasNext()) {
            stringBuffer.append(n + ": " + iteratorOfAllDrawables.next() + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

