/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          BatteryInfoDialog.h

Description:

    This file defines class BatteryInfoDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef BATTERYINFODIALOG_H
#define BATTERYINFODIALOG_H

//(*Headers(BatteryInfoDialog)
#include <wx/stattext.h>
#include <wx/statbox.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
//*)

#include "BatteryInfoMgmtProxy.h"
#include "PMGlobalConstant.h"

class BatteryInfoDialog: public wxDialog
{
	public:
        //constructor
		BatteryInfoDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		//destructor
		virtual ~BatteryInfoDialog();

		//(*Declarations(BatteryInfoDialog)
		wxStaticText* StaticText_UI_RemainPercentage;
		wxStaticText* StaticText_UI_BatteryStatus;
		wxStaticText* StaticText_UI_PowerSource;
		wxStaticText* StaticText_UI_BatteryName;
		wxStaticText* StaticText_UI_Voltage;
		wxStaticText* StaticText_Voltage;
//		wxStaticText* StaticText_RemainCapacity;
		wxStaticText* StaticText_PowerSource;
//		wxStaticText* StaticText_UI_RemainCapacity;
		wxStaticText* StaticText_FullCharge;
		wxStaticText* StaticText_DesignCapacity;
		wxStaticBitmap* StaticBitmap_BatteryInfoTop;
		wxStaticText* StaticText_UI_BatteryRemain;
		wxStaticText* StaticText_UI_DesignCapacity;
		wxButton* Button_OK;
		wxStaticText* StaticText_RemainTime;
		wxStaticBox* StaticBox_UI_PowerStatus;
		wxStaticText* StaticText_UI_RemainTime;
		wxStaticText* StaticText_BatteryStatus;
		wxComboBox* ComboBox_BatteryName;
		wxStaticText* StaticText_UI_FullCharge;
		wxStaticText* StaticText_RemainPercentage;
		wxStaticText* StaticText_BatteryRemain;
		wxStaticBox* StaticBox_UI_BatteryInformation;
		//*)

        wxStaticBitmap* StatusBmpAC;
        wxStaticBitmap* StatusBmpDC;
        //init dialog
        void InitDlg();
        //update battery info
        void UpdateInfo(PDCS_Battery_Info batteryInfo, int batteryIndex);

	protected:
		//(*Identifiers(BatteryInfoDialog)
		static const long ID_STATICBITMAP_BATTERYINFOTOP;
		static const long ID_STATICBOX_UI_POWERSTATUS;
		static const long ID_STATICBOX_UI_BATTERYINFORMATION;
		static const long ID_BUTTON_OK;
		static const long ID_STATICTEXT_UI_POWERSOURCE;
		static const long ID_STATICTEXT_UI_BATTERYREMAIN;
		static const long ID_STATICTEXT_POWERSOURCE;
		static const long ID_STATICTEXT_BatteryRemain;
		static const long ID_STATICTEXT_UI_BATTERYNAME;
		static const long ID_COMBOBOX_BATTERYNAME;
		static const long ID_STATICTEXT_UI_BATTERYSTATUS;
		static const long ID_STATICTEXT_BATTERYSTATUS;
		static const long ID_STATICTEXT_UI_REMAINCAPACITY;
		static const long ID_STATICTEXT_REMAINCAPACITY;
		static const long ID_STATICTEXT_UI_REMAINPERCENTAGE;
		static const long ID_STATICTEXT_REMAINPERCENTAGE;
		static const long ID_STATICTEXT_UI_FULLCHARGE;
		static const long ID_STATICTEXT_FULLCHARGE;
		static const long ID_STATICTEXT_UI_REMAINTIME;
		static const long ID_STATICTEXT_REMAINTIME;
		static const long ID_STATICTEXT_UI_DESIGNCAPACITY;
		static const long ID_STATICTEXT_DESIGNCAPACITY;
		static const long ID_STATICTEXT_UI_VOLTAGE;
		static const long ID_STATICTEXT_VOLTAGE;
		//*)

	private:

		//(*Handlers(BatteryInfoDialog)
		void OnButton1Click(wxCommandEvent& event);
		//ok button click event handler
		void OnButton_OKClick(wxCommandEvent& event);
		//comboBox select event handler
		void OnComboBox_BatteryNameSelect(wxCommandEvent& event);
		//*)

        //map event
		DECLARE_EVENT_TABLE()

    private:
        //close the window event handler
        void OnClose(wxCloseEvent& event); // Click close button
};

#endif
