/* -*- C++ -*- */
/*************************************************************************
 * Copyright(c) 1995~2005  Masaharu Goto (cint@pcroot.cern.ch)
 *
 * For the licensing terms see the file COPYING
 *
 ************************************************************************/
/*******************************************************************
* constants.h
*
*******************************************************************/

#ifndef G__CONSTANTS_H
#define G__CONSTANTS_H

const double PI = 3.141592653590; // the circular constant

const double E0 = 8.854e-12;// absolute permittivity of vacuum (F/m)
const double U0 = 4*PI*1e-7; // absolute permeability of vacuum (H/m)

const double E = 1.60210e-19; // charge of an electron (C)

const double ME = 9.1091e-31; // mass of an electron (kg)
const double MA = 1.67252e-27; // mass of a proton (kg)

const double C0 = 2.997925e8; // light velocity in vacuum (m/sec)

const double KCU = 5.800e7; // cupper consuctivity (moh/m)

const double G = 9.807; // gravity accelaration (m/sec^2)

const double K = 1.380e-23; // Boltzmann's constant (J/K)
const double H = 6.625e-34; // Planck's constant (J*sec)
const double N = 6.025e26; // Avogadro's number (1/kg/mol)

#endif
