//===========================================================================
// Copyright (c) 1996-2009 Synaptics Incorporated. All rights reserved.
//
// RCS Header - Do not delete or modify.
//
// $RCSfile: WinDef.h,v $
// $Source: /cvs/software/Driver/Linux/Include/WinDef.h,v $
//===========================================================================

//--------------------------------------------------------------------------
// Linux version WinDef.h
//--------------------------------------------------------------------------

#ifndef __WinDef_H
#define __WinDef_H

#include <stdint.h>
#include <unistd.h>

// common #defines
#ifndef FALSE
#define FALSE               0
#endif

#ifndef TRUE
#define TRUE                1
#endif

#ifndef CONST
#define CONST               const
#endif

#ifndef UNALIGNED
#define UNALIGNED
#endif

#define MAX_PATH          MAXPATHLEN

// common function prototypes used in Win32
#ifndef WINBASEAPI
#define WINBASEAPI inline
#endif

#ifndef WINUSERAPI
#define WINUSERAPI inline
#endif

// Other Defines to make transparent
#define APIENTRY
#define FAR
#define UNREFERENCED_PARAMETER(x)
#define WINAPI
#define CALLBACK
#define MAKEWORD(a, b)      ((WORD)(((BYTE)((DWORD_PTR)(a) & 0xff)) | ((WORD)((BYTE)((DWORD_PTR)(b) & 0xff))) << 8))
#define MAKELONG(a, b)      ((LONG)(((WORD)((DWORD_PTR)(a) & 0xffff)) | ((DWORD)((WORD)((DWORD_PTR)(b) & 0xffff))) << 16))
#define LOWORD(l)           ((WORD)((DWORD_PTR)(l) & 0xffff))
#define HIWORD(l)           ((WORD)((DWORD_PTR)(l) >> 16))
#define LOBYTE(w)           ((BYTE)((DWORD_PTR)(w) & 0xff))
#define HIBYTE(w)           ((BYTE)((DWORD_PTR)(w) >> 8))


typedef int (FAR WINAPI *FARPROC)();


#ifndef BASETYPES
#define BASETYPES
typedef uint32_t ULONG;
typedef ULONG *PULONG;
typedef unsigned short USHORT;
typedef USHORT *PUSHORT;
typedef unsigned char UCHAR;
typedef UCHAR *PUCHAR;
typedef char *PSZ;
typedef const char *PCSZ;
typedef int32_t             LONG;
typedef int64_t             LONGLONG;
typedef short               SHORT;
typedef USHORT              *PUSHORT;
typedef uint32_t            DWORD32;
typedef uint64_t            DWORD64;
typedef uint64_t            ULONGLONG;
typedef uint64_t            ULONG64;
typedef ULONG               DWORD;
typedef DWORD               *PDWORD;
typedef int                 BOOL;
typedef unsigned char       BYTE;
typedef unsigned short      WORD;
typedef float               FLOAT;
typedef double              DOUBLE;
typedef FLOAT               *PFLOAT;
typedef BOOL                *PBOOL;
typedef BOOL                *LPBOOL;
typedef BOOL		            BOOLEAN;
typedef BYTE                *PBYTE;
typedef BYTE                *LPBYTE;
typedef int                 *PINT;
typedef int                 *LPINT;
typedef WORD                *PWORD;
typedef WORD                *LPWORD;
typedef long                *LPLONG;
typedef SHORT               *PSHORT;
typedef LONG                *PLONG;
typedef size_t              SIZE_T;
typedef SIZE_T              *PSIZE_T;
typedef ssize_t             SSIZE_T;
typedef SSIZE_T             *PSSIZE_T;
typedef DWORD               *PDWORD;
typedef DWORD               *LPDWORD;
typedef void                VOID;
typedef VOID                *PVOID;
typedef VOID                *LPVOID;
typedef CONST void          *LPCVOID;
typedef int                 INT;
typedef unsigned int        UINT;
typedef uint32_t            UINT32;
typedef uint64_t            UINT64;
typedef unsigned int        *PUINT;
typedef USHORT              *PUSHORT;
typedef UINT32              *PUINT32;
typedef UINT64              *PUINT64;
typedef ULONG               *PULONG;
typedef signed int          INT32;
#if defined(_WIN64)
typedef int64_t             INT_PTR, *PINT_PTR;
typedef uint64_t            UINT_PTR, *PUINT_PTR;
typedef int64_t             LONG_PTR, *PLONG_PTR;
typedef uint64_t            ULONG_PTR, *PULONG_PTR;
#else
typedef int                 INT_PTR, *PINT_PTR;
typedef unsigned int        UINT_PTR, *PUINT_PTR;
typedef long                LONG_PTR, *PLONG_PTR;
typedef unsigned long       ULONG_PTR, *PULONG_PTR;
#endif
typedef ULONG_PTR           DWORD_PTR, *PDWORD_PTR;
typedef int                 HFILE;

typedef PVOID               HANDLE;
typedef HANDLE              HINSTANCE;
typedef HANDLE              HBITMAP;
typedef HANDLE              HBRUSH;
typedef HANDLE              HCURSOR;
typedef HANDLE              HDC;
typedef HANDLE              HDROP;
typedef HANDLE              HGDIOBJ;
typedef HANDLE              HICON;
typedef HANDLE              HKEY;
typedef HKEY                *PHKEY;
typedef HANDLE              HLOCAL;
typedef HANDLE              HMENU;
typedef HANDLE              HMODULE;
typedef HANDLE              HPROPSHEETPAGE;
typedef HANDLE              HRGN;
typedef HANDLE              HWND;
typedef HANDLE              HMIXER;

typedef UINT_PTR            WPARAM;
typedef LONG_PTR            LPARAM;
typedef LONG_PTR            LRESULT;
#endif  /* !BASETYPES */

typedef union _LARGE_INTEGER {
  struct {
    DWORD LowPart;
    LONG HighPart;
  } ;
  struct {
    DWORD LowPart;
    LONG HighPart;
  } u;
  LONGLONG QuadPart;
} LARGE_INTEGER, *PLARGE_INTEGER;

typedef struct tagPOINT
{
    LONG  x;
    LONG  y;
} POINT, *PPOINT, *LPPOINT;

typedef struct tagRECT
{
    LONG    left;
    LONG    top;
    LONG    right;
    LONG    bottom;
} RECT, *LPRECT;

typedef const RECT *LPCRECT;

typedef struct tagSIZE
{
    LONG        cx;
    LONG        cy;
} SIZE, *PSIZE, *LPSIZE;

// the HRESULT
typedef LONG HRESULT;
typedef HRESULT STDMETHODIMP;

#define __stdcall
#define STDAPICALLTYPE          __stdcall
#define STDAPI   HRESULT STDAPICALLTYPE
#define _TRUNCATE ((size_t)-1)

typedef char                CHAR;
typedef wchar_t             WCHAR;

// common string types used in windows
// we assume unicode versions in linux.
typedef WCHAR *PWCHAR, *LPWCH, *PWCH;
typedef CONST WCHAR *LPCWCH, *PCWCH;
typedef WCHAR *NWPSTR, *LPWSTR, *PWSTR;
typedef PWSTR *PZPWSTR;
typedef CONST PWSTR *PCZPWSTR;
typedef WCHAR UNALIGNED *LPUWSTR, *PUWSTR;
typedef CONST WCHAR *LPCWSTR, *PCWSTR;
typedef PCWSTR *PZPCWSTR;
typedef CONST WCHAR UNALIGNED *LPCUWSTR, *PCUWSTR;
typedef DWORD   COLORREF;
typedef DWORD   *LPCOLORREF;

/* Macros to retrieve CMYK values from a COLORREF from WinGDI.h */
#define GetKValue(cmyk)      ((BYTE)(cmyk))
#define GetYValue(cmyk)      ((BYTE)((cmyk)>> 8))
#define GetMValue(cmyk)      ((BYTE)((cmyk)>>16))
#define GetCValue(cmyk)      ((BYTE)((cmyk)>>24))
typedef void 		*HKL;
typedef HKL   	*LPHKL;

//
// ANSI (Multi-byte Character) types
//
typedef CHAR *PCHAR, *LPCH, *PCH;
typedef CONST CHAR *LPCCH, *PCCH;

typedef CHAR *NPSTR, *LPSTR, *PSTR;
typedef PSTR *PZPSTR;
typedef CONST PSTR *PCZPSTR;
typedef CONST CHAR *LPCSTR, *PCSTR;
typedef PCSTR *PZPCSTR;
typedef wchar_t *LPCOLESTR;

#ifdef UNICODE

typedef WCHAR    TCHAR;

typedef LPWSTR   PTCH, LPTCH;
typedef LPWSTR   PTSTR, LPTSTR;
typedef LPCWSTR  PCTSTR, LPCTSTR;
typedef LPUWSTR  PUTSTR, LPUTSTR;
typedef LPCUWSTR PCUTSTR, LPCUTSTR;
typedef LPWSTR   LP;

#define __TEXT(quote) L##quote

#else // UNICODE

typedef CHAR     TCHAR;

typedef LPSTR    PTCH, LPTCH;
typedef LPSTR    PTSTR, LPTSTR;
typedef LPCSTR   PCTSTR, LPCTSTR;
typedef LPSTR    PUTSTR, LPUTSTR;
typedef LPCSTR   PCUTSTR, LPCUTSTR;
typedef LPSTR    LP;

#define __TEXT(quote) quote 

#endif // UNICODE

#define TEXT(quote) __TEXT(quote)

//
// Success codes
//
#define S_OK                                   ((HRESULT)0x00000000L)
#define S_FALSE                                ((HRESULT)0x00000001L)

#define _tzset          tzset

#endif // __WinDef_H
