/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;

public class Display
implements Scrollable {
    DoctorPanel doctor;
    boolean firsttime = true;
    Image uw;
    boolean valid = false;
    Scroller scroller;
    FontMetrics fontMetric;
    Vector dataList;
    int nrows;
    int ncols;
    Rectangle out;
    Rectangle in;
    boolean vertical = false;
    String title;
    String description;
    int period = 5;
    boolean persistent = false;
    String presentation = "line";
    String orientation = "horizontal";
    int timeScale = 60;
    boolean fillArea = false;
    String filterColumn = "none";
    String filterValue;
    int selectedRow = -1;
    String timeformat;
    Color backgroundcolor = Color.white;
    Color axiscolor = Color.black;
    Color linecolor = Color.red;
    Color fillcolor = Color.orange;
    Color fontcolor = Color.black;
    Color gridcolor = Color.white;
    Color titlecolor = Color.black;
    Font font = new Font("Helvetica", 0, 12);
    Font titlefont = new Font("Helvetica", 1, 12);
    double xmin;
    double xmax = 1.0;
    String xunits;
    int xticks;
    String xlabel = " ";
    double ymin;
    double ymax;
    int yticks;
    int yfactor = 1;
    String ylabel = "";

    public Display(DoctorPanel doctorPanel) {
        this.doctor = doctorPanel;
        this.init();
    }

    private void init() {
        Utility utility = this.doctor.app.utility;
        this.title = utility.readString(this.title, "title");
        int n = utility.readInteger(100, "width");
        int n2 = utility.readInteger(100, "height");
        this.out = new Rectangle(0, 0, n, n2);
        this.in = new Rectangle(60, 40, this.out.width - 80, this.out.height - 80);
        this.selectedRow = utility.readInteger(this.selectedRow, "selectedRow");
        this.timeformat = utility.readString(null, "timeformat");
        this.backgroundcolor = utility.readColor(this.backgroundcolor, "backgroundcolor");
        this.axiscolor = utility.readColor(this.axiscolor, "axiscolor");
        this.linecolor = utility.readColor(this.linecolor, "linecolor");
        this.fillcolor = utility.readColor(this.fillcolor, "fillcolor");
        this.fontcolor = utility.readColor(this.fontcolor, "fontcolor");
        this.gridcolor = utility.readColor(this.gridcolor, "gridcolor");
        this.titlecolor = utility.readColor(this.titlecolor, "titlecolor");
        this.font = utility.readFont(this.font, "font");
        this.titlefont = utility.readFont(this.titlefont, "titlefont");
        utility.readDouble(this.xmin, "xmin");
        utility.readDouble(this.xmax, "xmax");
        this.xlabel = utility.readString(this.xlabel, "xlabel");
        this.xunits = utility.readString(this.xunits, "xunits");
        this.xticks = utility.readInteger(this.xticks, "xticks");
        this.ylabel = utility.readString(this.ylabel, "ylabel");
        this.yticks = utility.readInteger(this.yticks, "yticks");
        this.ymax = utility.readDouble(this.ymax, "ymax");
        this.period = utility.readInteger(this.period, "period");
        this.persistent = utility.readBoolean(this.persistent, "persistent");
        this.presentation = utility.readString(this.presentation, "presentation");
        this.orientation = utility.readString(this.orientation, "orientation");
        this.timeScale = utility.readInteger(this.timeScale, "timeScale");
        this.fillArea = utility.readBoolean(this.fillArea, "fillArea");
        this.filterColumn = utility.readString(this.filterColumn, "filterColumn");
        this.filterValue = utility.readString(this.filterValue, "filterValue");
    }

    public int intValue(int n, String string) {
        try {
            Integer n2 = new Integer(string);
            if (n2 != null) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public double doubleValue(double d, String string) {
        try {
            Double d2 = Double.valueOf(string);
            if (d2 != null) {
                return d2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return d;
    }

    public void removeDataAt(int n, int n2) {
        int n3 = 0;
        while (n3 < this.dataList.size()) {
            Data data = (Data)this.dataList.elementAt(n3);
            if (data.row == n && data.col == n2) {
                this.dataList.removeElementAt(n3);
                return;
            }
            ++n3;
        }
    }

    public Data dataAt(int n, int n2) {
        int n3 = 0;
        while (n3 < this.dataList.size()) {
            Data data = (Data)this.dataList.elementAt(n3);
            if (data.row == n && data.col == n2) {
                return data;
            }
            ++n3;
        }
        return null;
    }

    public int numberOfRows() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.dataList.size()) {
            Data data = (Data)this.dataList.elementAt(n2);
            if (data.row > n) {
                n = data.row;
            }
            ++n2;
        }
        return n + 1;
    }

    public void readData(Vector vector) {
        int n = 0;
        int n2 = 0;
        this.nrows = 0;
        this.ncols = 0;
        this.dataList = new Vector();
        int n3 = 0;
        int n4 = 0;
        while (n4 < vector.size()) {
            String string;
            String string2 = (String)vector.elementAt(n4);
            Vector vector2 = this.doctor.app.utility.getListOfStrings(string2);
            if (vector2.size() > 0 && (string = (String)vector2.elementAt(0)) != null) {
                if (string.equals("title:")) {
                    this.title = new String((String)vector2.elementAt(1));
                } else if (string.equals("column:")) {
                    String string3 = (String)vector2.elementAt(1);
                    this.dataList.addElement(new Data(0, -1, n++, string3));
                } else if (string.equals("data:")) {
                    ++n3;
                    n2 = this.intValue(-1, (String)vector2.elementAt(1));
                    int n5 = this.intValue(-1, (String)vector2.elementAt(2));
                    int n6 = this.intValue(-1, (String)vector2.elementAt(3));
                    String string4 = (String)vector2.elementAt(4);
                    if (n5 >= 0 && n6 >= 0 && string4 != null) {
                        this.dataAt(n5, n6);
                        this.dataList.addElement(new Data(n2, n5, n6, string4));
                        if (n5 >= this.nrows - 1) {
                            this.nrows = n5 + 1;
                        }
                        if (n6 >= this.ncols - 1) {
                            this.ncols = n6 + 1;
                        }
                    }
                }
            }
            ++n4;
        }
    }

    public void setScroller(Scroller scroller) {
        this.scroller = scroller;
    }

    public Rectangle getRect() {
        return this.out;
    }

    public int getWidth() {
        return this.out.width;
    }

    public int getHeight() {
        return this.out.height;
    }

    public void moveBy(int n, int n2) {
        this.out.x += n;
        this.out.y += n2;
    }

    public boolean mouseHit(int n, int n2) {
        int n3 = this.out.x;
        int n4 = this.out.y;
        int n5 = this.out.x + this.out.width;
        int n6 = this.out.y + this.out.height;
        return n > n3 && n < n5 && n2 > n4 && n2 < n6;
    }

    public void toggleFill() {
        if (this.fillArea) {
            this.fillArea = false;
            return;
        }
        this.fillArea = true;
    }

    public void drawTitle(Graphics graphics) {
        graphics.setColor(this.fontcolor);
        this.fontMetric = graphics.getFontMetrics(this.titlefont);
        int n = this.fontMetric.stringWidth(this.title);
        int n2 = (int)(0.5 * (double)(this.out.width - n));
        this.fontMetric.getHeight();
        graphics.setFont(this.titlefont);
        graphics.setColor(this.titlecolor);
        graphics.drawString(this.title, n2, 20);
    }

    public void invalidate() {
        this.valid = false;
    }

    public void drawOffScreen() {
        Graphics graphics = null;
        this.uw = this.doctor.createImage(this.out.width, this.out.height);
        if (this.uw != null) {
            graphics = this.uw.getGraphics();
        }
        if (graphics != null) {
            this.drawIt(graphics);
        }
        this.valid = true;
    }

    public void drawIt(Graphics graphics) {
    }

    public void draw(Graphics graphics) {
        if (!this.valid) {
            this.drawOffScreen();
        }
        graphics.drawImage(this.uw, this.out.x, this.out.y, this.doctor);
    }
}

